/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.symtable;

import com.intellij.openapi.util.Pair;
import com.intellij.rml.dfa.attributes.Attribute;
import com.intellij.rml.dfa.attributes.IntAttribute;
import com.intellij.rml.dfa.impl.WrongAttributeException;
import com.intellij.rml.dfa.impl.domains.AttributesInfo;
import com.intellij.rml.dfa.impl.domains.DomainType;
import com.intellij.rml.dfa.impl.domains.DomainTypeManager;
import com.intellij.rml.dfa.impl.providers.RmlProviderDescriptor;
import com.intellij.rml.dfa.impl.symtable.AttributesComparator;
import com.intellij.rml.dfa.impl.symtable.SymbolTable;
import com.intellij.rml.dfa.impl.ui.Messages;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MutableSymbolTable
implements SymbolTable {
    private final RmlProviderDescriptor descriptor;
    protected final DomainTypeManager typeManager;
    protected final int availableTypesCnt;
    protected final Set<Attribute>[] attributesSet;
    private final Map<Attribute, Pair<String, String>>[] attributeSources;
    private final List<Attribute>[] attributes;
    private final Map<String, Integer>[] backwardMap;
    private final Map<DomainType, AttributesInfo> domainTypeInfos;
    private boolean modified = true;

    public MutableSymbolTable(DomainTypeManager typeManager, RmlProviderDescriptor descriptor, boolean trackSources) {
        this.typeManager = typeManager;
        this.descriptor = descriptor;
        this.availableTypesCnt = typeManager.getDomainTypesCount();
        this.attributesSet = new Set[this.availableTypesCnt];
        this.attributeSources = trackSources ? new Map[this.availableTypesCnt] : null;
        this.attributes = new List[this.availableTypesCnt];
        this.backwardMap = new Map[this.availableTypesCnt];
        this.domainTypeInfos = new HashMap<DomainType, AttributesInfo>();
        for (int i = 0; i < this.availableTypesCnt; ++i) {
            this.attributesSet[i] = new HashSet<Attribute>();
            DomainType domainType = typeManager.getDomainType(i);
            if (domainType.isIntegerType()) {
                this.domainTypeInfos.put(domainType, AttributesInfo.Companion.create(domainType));
            }
            if (!trackSources) continue;
            this.attributeSources[i] = new HashMap<Attribute, Pair<String, String>>();
        }
    }

    public List<Attribute> getAttributes(int domainTypeIndex) {
        return this.attributes[domainTypeIndex];
    }

    public void addAttributesFrom(List<SymbolTable> tables) {
        this.modified = true;
        for (int i = 0; i < this.availableTypesCnt; ++i) {
            DomainType domainType = this.typeManager.getDomainType(i);
            for (SymbolTable table : tables) {
                if (domainType.isIntegerType()) {
                    AttributesInfo sourceAttributesInfo = table.getAttributesInfo(domainType);
                    AttributesInfo destAttributesInfo = this.getAttributesInfo(domainType);
                    int newAttrsCnt = sourceAttributesInfo.getNumOfAttributes() - destAttributesInfo.getNumOfAttributes();
                    if (newAttrsCnt <= 0) continue;
                    destAttributesInfo.addAttributes(newAttrsCnt);
                    continue;
                }
                if (this.attributeSources != null) {
                    for (Attribute attribute : table.getAttributes(domainType)) {
                        this.addAttribute(attribute, domainType, "Migrated from", table.toString());
                    }
                    continue;
                }
                this.attributesSet[i].addAll(table.getAttributes(domainType));
            }
        }
    }

    public void sortAttributes() {
        if (!this.modified) {
            return;
        }
        this.modified = false;
        AttributesComparator comparator2 = new AttributesComparator();
        for (int i = 0; i < this.availableTypesCnt; ++i) {
            DomainType domainType = this.typeManager.getDomainType(i);
            if (domainType.isIntegerType()) continue;
            this.attributes[i] = new ArrayList<Attribute>();
            this.backwardMap[i] = new HashMap<String, Integer>();
            this.domainTypeInfos.put(domainType, AttributesInfo.Companion.create(domainType));
            for (Attribute attribute : this.attributesSet[i].stream().sorted(comparator2).toList()) {
                this.attributes[i].add(attribute);
                AttributesInfo attributesInfo = this.getAttributesInfo(domainType);
                int index = attributesInfo.addAttribute();
                this.backwardMap[i].put(attribute.getKey(), index);
            }
        }
    }

    @Override
    @NotNull
    public DomainTypeManager getTypeManager() {
        DomainTypeManager domainTypeManager = this.typeManager;
        if (domainTypeManager == null) {
            MutableSymbolTable.$$$reportNull$$$0(0);
        }
        return domainTypeManager;
    }

    @Override
    @NotNull
    public AttributesInfo getAttributesInfo(@NotNull DomainType type) {
        if (type == null) {
            MutableSymbolTable.$$$reportNull$$$0(1);
        }
        AttributesInfo attributesInfo = this.domainTypeInfos.get(type);
        if (attributesInfo == null) {
            MutableSymbolTable.$$$reportNull$$$0(2);
        }
        return attributesInfo;
    }

    @Override
    public boolean containsAttribute(int domainTypeIndex, @NotNull Attribute attribute) {
        if (attribute == null) {
            MutableSymbolTable.$$$reportNull$$$0(3);
        }
        return this.backwardMap[domainTypeIndex].containsKey(attribute.getKey());
    }

    @Override
    public int getAttributeInt(DomainType type, @NotNull String attribute) {
        if (attribute == null) {
            MutableSymbolTable.$$$reportNull$$$0(4);
        }
        if (type.isIntegerType()) {
            return Integer.parseInt(attribute);
        }
        Integer value = this.backwardMap[type.getIndex()].get(attribute);
        if (value == null) {
            throw new WrongAttributeException(this.toString(), Messages.getString(SymbolTable.class.getName() + "-1") + attribute + "\"");
        }
        return value;
    }

    @Override
    @Nullable
    public Integer getAttributeIntOrNull(@NotNull DomainType type, @NotNull String attribute) {
        if (type == null) {
            MutableSymbolTable.$$$reportNull$$$0(5);
        }
        if (attribute == null) {
            MutableSymbolTable.$$$reportNull$$$0(6);
        }
        if (type.isIntegerType()) {
            return Integer.parseInt(attribute);
        }
        return this.backwardMap[type.getIndex()].get(attribute);
    }

    @Override
    @NotNull
    public Attribute getAttribute(DomainType domainType, int value) {
        if (domainType.isIntegerType()) {
            return new IntAttribute(value);
        }
        List<Attribute> attributes = this.attributes[domainType.getIndex()];
        return value < attributes.size() ? attributes.get(value) : new Attribute("<unknown>");
    }

    @Override
    @NotNull
    public List<Attribute> getAttributes(@NotNull DomainType domainType) {
        if (domainType == null) {
            MutableSymbolTable.$$$reportNull$$$0(7);
        }
        List<Attribute> list = this.attributes[domainType.getIndex()];
        if (list == null) {
            MutableSymbolTable.$$$reportNull$$$0(8);
        }
        return list;
    }

    public boolean addAttribute(Attribute attribute, DomainType domainType, String sourceKind, String source) {
        this.modified = true;
        if (domainType.isIntegerType()) {
            AttributesInfo attributesInfo = this.getAttributesInfo(domainType);
            int value = Integer.parseInt(attribute.getKey());
            if (value >= attributesInfo.getNumOfAttributes()) {
                attributesInfo.addAttributes(value - attributesInfo.getNumOfAttributes() + 1);
                return true;
            }
        } else if (this.attributesSet[domainType.getIndex()].add(attribute)) {
            if (this.attributeSources != null) {
                this.attributeSources[domainType.getIndex()].put(attribute, (Pair<String, String>)Pair.create((Object)sourceKind, (Object)source));
            }
            return true;
        }
        return false;
    }

    public boolean isModified() {
        return this.modified;
    }

    @Override
    public Map<Attribute, Pair<String, String>>[] getAttributeSources() {
        return this.attributeSources;
    }

    public String toString() {
        return this.descriptor.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/rml/dfa/impl/symtable/MutableSymbolTable";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domainType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeManager";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/rml/dfa/impl/symtable/MutableSymbolTable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributesInfo";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAttributesInfo";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "containsAttribute";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeInt";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeIntOrNull";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

