/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.build.FileNavigatable;
import com.intellij.build.FilePosition;
import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.pom.Navigatable;
import com.intellij.util.text.VersionComparatorUtil;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.buildtool.quickfix.OpenMavenSettingsQuickFix;
import org.jetbrains.idea.maven.execution.SyncBundle;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.server.RestartMavenEmbeddersQuickFix;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenCoreInitializationFailureIssue
implements BuildIssue {
    @NlsSafe
    private final String myMessage;
    private final Set<String> myMultimoduleDirectories;
    private final String myMavenVersion;
    private final MavenId myUnresolvedExtensionId;

    public MavenCoreInitializationFailureIssue(@NlsSafe String message, @NotNull Set<String> multimoduleDirectories, @Nullable String mavenVersion, @Nullable MavenId unresolvedExtensionId) {
        if (multimoduleDirectories == null) {
            MavenCoreInitializationFailureIssue.$$$reportNull$$$0(0);
        }
        this.myMessage = message;
        this.myMultimoduleDirectories = multimoduleDirectories;
        this.myMavenVersion = mavenVersion;
        this.myUnresolvedExtensionId = unresolvedExtensionId;
    }

    @NotNull
    public String getTitle() {
        String string = SyncBundle.message("maven.core.plexus.init.issue.title", new Object[0]);
        if (string == null) {
            MavenCoreInitializationFailureIssue.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getDescription() {
        StringBuilder desc = new StringBuilder(SyncBundle.message("maven.core.plexus.init.issue.description", new Object[0]));
        if (this.myMavenVersion == null || VersionComparatorUtil.compare((String)"3.8.5", (String)this.myMavenVersion) <= 0) {
            desc.append("\n").append(SyncBundle.message("maven.core.plexus.init.issue.fix.downgrade", "open_maven_settings_quick_fix"));
        }
        desc.append("\n").append(SyncBundle.message("maven.core.plexus.init.issue.fix.remove", "RESTART_MAVEN_QUICK_FIX_ID"));
        desc.append("\n\n\n").append(SyncBundle.message("maven.core.plexus.init.issue.description.exception", new Object[0]));
        desc.append("\n").append(this.myMessage);
        String string = desc.toString();
        if (string == null) {
            MavenCoreInitializationFailureIssue.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public List<BuildIssueQuickFix> getQuickFixes() {
        List<BuildIssueQuickFix> list = List.of(new RestartMavenEmbeddersQuickFix(), new OpenMavenSettingsQuickFix());
        if (list == null) {
            MavenCoreInitializationFailureIssue.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    public Navigatable getNavigatable(@NotNull Project project) {
        if (project == null) {
            MavenCoreInitializationFailureIssue.$$$reportNull$$$0(4);
        }
        for (String directory : this.myMultimoduleDirectories) {
            Path extensions = Path.of(directory, new String[0]).resolve(".mvn").resolve("extensions.xml");
            if (!extensions.toFile().isFile() || !MavenUtil.containsDeclaredExtension(extensions, this.myUnresolvedExtensionId)) continue;
            return new FileNavigatable(project, new FilePosition(extensions.toFile(), 0, 0));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "multimoduleDirectories";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/server/MavenCoreInitializationFailureIssue";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/server/MavenCoreInitializationFailureIssue";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNavigatable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

