/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.couchbase;

import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.dialects.BaseDatabaseErrorHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CouchbaseErrorHandler
extends BaseDatabaseErrorHandler {
    @NotNull
    protected ErrorInfo getErrorInfo(@NotNull Project project, @Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
        if (project == null) {
            CouchbaseErrorHandler.$$$reportNull$$$0(0);
        }
        if (original == null) {
            CouchbaseErrorHandler.$$$reportNull$$$0(1);
        }
        if (cause == null) {
            CouchbaseErrorHandler.$$$reportNull$$$0(2);
        }
        String noDocsMsg = "has no documents";
        String causeMsg = GridUtilCore.getMessage((Throwable)cause);
        if (StringUtil.containsIgnoreCase((String)causeMsg, (String)noDocsMsg)) {
            return new CouchCauseHasNoDocument(dataSource, original, cause);
        }
        String origMsg = GridUtilCore.getMessage((Throwable)original);
        if (StringUtil.containsIgnoreCase((String)origMsg, (String)noDocsMsg)) {
            return new CouchOriginalHasNoDocument(dataSource, original, cause);
        }
        ErrorInfo errorInfo = super.getErrorInfo(project, dataSource, original, cause);
        if (errorInfo == null) {
            CouchbaseErrorHandler.$$$reportNull$$$0(3);
        }
        return errorInfo;
    }

    public int getErrorOffset(@NotNull Project project, @NotNull ErrorInfo errorInfo, @NotNull String queryText) {
        if (project == null) {
            CouchbaseErrorHandler.$$$reportNull$$$0(4);
        }
        if (errorInfo == null) {
            CouchbaseErrorHandler.$$$reportNull$$$0(5);
        }
        if (queryText == null) {
            CouchbaseErrorHandler.$$$reportNull$$$0(6);
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/couchbase/CouchbaseErrorHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorInfo";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/couchbase/CouchbaseErrorHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getErrorInfo";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getErrorOffset";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private static class CouchCauseHasNoDocument
    extends BaseDatabaseErrorHandler.DatabaseErrorInfo {
        CouchCauseHasNoDocument(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
            if (original == null) {
                CouchCauseHasNoDocument.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                CouchCauseHasNoDocument.$$$reportNull$$$0(1);
            }
            super(dataSource, original, cause);
        }

        protected void fillInfoData(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            if (sb == null) {
                CouchCauseHasNoDocument.$$$reportNull$$$0(2);
            }
            if (fixes == null) {
                CouchCauseHasNoDocument.$$$reportNull$$$0(3);
            }
            this.appendOriginalPrefixIfNeeded(sb);
            sb.append(GridUtilCore.getMessage((Throwable)this.myCause));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/couchbase/CouchbaseErrorHandler$CouchCauseHasNoDocument";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillInfoData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CouchOriginalHasNoDocument
    extends BaseDatabaseErrorHandler.DatabaseErrorInfo {
        CouchOriginalHasNoDocument(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
            if (original == null) {
                CouchOriginalHasNoDocument.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                CouchOriginalHasNoDocument.$$$reportNull$$$0(1);
            }
            super(dataSource, original, cause);
        }

        protected void fillInfoData(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            if (sb == null) {
                CouchOriginalHasNoDocument.$$$reportNull$$$0(2);
            }
            if (fixes == null) {
                CouchOriginalHasNoDocument.$$$reportNull$$$0(3);
            }
            sb.append(GridUtilCore.getMessage((Throwable)this.myOriginal));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/couchbase/CouchbaseErrorHandler$CouchOriginalHasNoDocument";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillInfoData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

