/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.hsql;

import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.Either;
import com.intellij.database.dataSource.connection.EitherKt;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatementFactoryService;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dataSource.connection.statements.StatementParameters;
import com.intellij.database.dialects.AbstractDefinitionProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.util.PairConsumer;
import org.jetbrains.annotations.NotNull;

public final class HsqlDefinitionProvider
extends AbstractDefinitionProvider {
    private static final String ROUTINE_STMT = "SELECT ROUTINE_DEFINITION FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_SCHEMA=? AND ROUTINE_NAME=?";

    public boolean isSupported(@NotNull DasObject object) {
        ObjectKind kind;
        if (object == null) {
            HsqlDefinitionProvider.$$$reportNull$$$0(0);
        }
        return (kind = object.getKind()) == ObjectKind.ROUTINE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fetchSources(@NotNull Iterable<? extends DasObject> objects, @NotNull DatabaseConnectionCore connection, @NotNull PairConsumer<DasObject, Object> consumer) {
        if (objects == null) {
            HsqlDefinitionProvider.$$$reportNull$$$0(1);
        }
        if (connection == null) {
            HsqlDefinitionProvider.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            HsqlDefinitionProvider.$$$reportNull$$$0(3);
        }
        ReusableSmartStatement routineStmt = null;
        try {
            routineStmt = SmartStatementFactoryService.getInstance().poweredBy(connection).parameterized().reuse(ROUTINE_STMT);
            for (DasObject dasObject : objects) {
                ObjectKind kind = dasObject.getKind();
                if (kind != ObjectKind.ROUTINE) continue;
                ReusableSmartStatement statement = routineStmt;
                consumer.consume((Object)dasObject, EitherKt.any((Either)statement.execute((Object)new StatementParameters().text(DasUtil.getSchema((DasObject)dasObject)).text(dasObject.getName()).asDecoration(), StandardResultsProcessors.FIRST_STRING)));
            }
        }
        catch (Throwable throwable) {
            DbImplUtilCore.closeSafe(routineStmt);
            throw throwable;
        }
        DbImplUtilCore.closeSafe((AutoCloseable)routineStmt);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dialects/hsql/HsqlDefinitionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupported";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fetchSources";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

