/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.reference;

import com.google.common.collect.Lists;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.javascript.JSModuleBaseReference;
import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.ResolvedModuleInfo;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.frameworks.modules.JSFileModuleReference;
import com.intellij.lang.javascript.frameworks.modules.JSReferencePathUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceOwner;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileReference;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NodeFileModulePsiReferenceBase
implements PsiReference,
JSModuleBaseReference,
FileReferenceOwner,
PsiFileReference {
    protected final PsiElement myPsiElement;
    protected final String myRequiredModuleName;
    private final int myOffset;
    private final int myOriginalLength;

    public NodeFileModulePsiReferenceBase(@NotNull PsiElement literalOrModuleReferenceOwner, @NotNull String requiredModuleName, int offset) {
        if (literalOrModuleReferenceOwner == null) {
            NodeFileModulePsiReferenceBase.$$$reportNull$$$0(0);
        }
        if (requiredModuleName == null) {
            NodeFileModulePsiReferenceBase.$$$reportNull$$$0(1);
        }
        this.myPsiElement = literalOrModuleReferenceOwner;
        this.myOriginalLength = requiredModuleName.length();
        this.myRequiredModuleName = JSStringUtil.unescapeStringLiteralValue((String)requiredModuleName);
        this.myOffset = offset;
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.myPsiElement;
        if (psiElement == null) {
            NodeFileModulePsiReferenceBase.$$$reportNull$$$0(2);
        }
        return psiElement;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = TextRange.from((int)this.myOffset, (int)this.myOriginalLength);
        if (textRange == null) {
            NodeFileModulePsiReferenceBase.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    public PsiElement resolve() {
        ResolvedModuleInfo resolvedModuleInfo = this.resolveModule();
        if (resolvedModuleInfo == null) {
            return null;
        }
        VirtualFile resolvedVirtualFile = resolvedModuleInfo.getModuleMainFile();
        if (resolvedVirtualFile.isValid()) {
            return this.myPsiElement.getManager().findFile(resolvedVirtualFile);
        }
        return null;
    }

    @Nullable
    public final ResolvedModuleInfo resolveModule() {
        ResolvedModuleInfo module = this.doResolveModule();
        return module != null ? this.getCanonicalModuleInProject(module) : null;
    }

    @Nullable
    protected abstract ResolvedModuleInfo doResolveModule();

    @NotNull
    private ResolvedModuleInfo getCanonicalModuleInProject(@NotNull ResolvedModuleInfo info) {
        VirtualFile canonicalModule;
        String relativePath;
        VirtualFile canonicalRoot;
        VirtualFile root;
        if (info == null) {
            NodeFileModulePsiReferenceBase.$$$reportNull$$$0(4);
        }
        if (!(root = info.getModuleSourceRoot()).equals(canonicalRoot = JSFileModuleReference.getCanonicalPreferredFile(this.myPsiElement.getProject(), root)) && (relativePath = VfsUtilCore.getRelativePath((VirtualFile)info.getModuleMainFile(), (VirtualFile)root)) != null && (canonicalModule = canonicalRoot.findFileByRelativePath(relativePath)) != null) {
            return new ResolvedModuleInfo(canonicalRoot, canonicalModule, info.getType());
        }
        ResolvedModuleInfo resolvedModuleInfo = info;
        if (resolvedModuleInfo == null) {
            NodeFileModulePsiReferenceBase.$$$reportNull$$$0(5);
        }
        return resolvedModuleInfo;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myRequiredModuleName;
        if (string == null) {
            NodeFileModulePsiReferenceBase.$$$reportNull$$$0(6);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newContent) throws IncorrectOperationException {
        if (newContent == null) {
            NodeFileModulePsiReferenceBase.$$$reportNull$$$0(7);
        }
        return null;
    }

    public PsiElement bindToElement(@NotNull PsiElement psiElement) throws IncorrectOperationException {
        if (psiElement == null) {
            NodeFileModulePsiReferenceBase.$$$reportNull$$$0(8);
        }
        return JSReferencePathUpdater.bindForModule(psiElement, this);
    }

    public boolean isReferenceTo(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            NodeFileModulePsiReferenceBase.$$$reportNull$$$0(9);
        }
        return this.myPsiElement.getManager().areElementsEquivalent(this.resolve(), psiElement);
    }

    public Object @NotNull [] getVariants() {
        Object[] objectArray = NodeFileModulePsiReferenceBase.toLookupElements(this.getContainingFile(), this.getElement(), this.getModuleInfos(this.getContainingFile())).toArray(LookupElement[]::new);
        if (objectArray == null) {
            NodeFileModulePsiReferenceBase.$$$reportNull$$$0(10);
        }
        return objectArray;
    }

    @NotNull
    public static Collection<LookupElement> toLookupElements(@Nullable VirtualFile requester, @NotNull PsiElement host, @NotNull CompletionModuleInfo[] modules) {
        if (host == null) {
            NodeFileModulePsiReferenceBase.$$$reportNull$$$0(11);
        }
        if (modules == null) {
            NodeFileModulePsiReferenceBase.$$$reportNull$$$0(12);
        }
        Arrays.sort(modules, Comparator.comparing(CompletionModuleInfo::getName));
        ArrayList lookupElements = Lists.newArrayListWithCapacity((int)modules.length);
        for (CompletionModuleInfo module : modules) {
            String name = module.getName();
            if (name.startsWith("@types/")) continue;
            lookupElements.add(NodeFileModulePsiReferenceBase.createLookupElement(requester, module, host.getProject()));
        }
        ArrayList arrayList = lookupElements;
        if (arrayList == null) {
            NodeFileModulePsiReferenceBase.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @NotNull
    public static LookupElement createLookupElement(@Nullable VirtualFile context2, @NotNull CompletionModuleInfo module, @NotNull Project project) {
        if (module == null) {
            NodeFileModulePsiReferenceBase.$$$reportNull$$$0(14);
        }
        if (project == null) {
            NodeFileModulePsiReferenceBase.$$$reportNull$$$0(15);
        }
        String lookupObject = module.getName();
        PsiFileSystemItem fileOrDir = PsiUtilCore.findFileSystemItem((Project)project, (VirtualFile)module.getVirtualFile());
        if (fileOrDir != null) {
            lookupObject = fileOrDir;
        }
        LookupElementBuilder element2 = LookupElementBuilder.create((Object)lookupObject, (String)module.getName()).withIcon(AllIcons.Nodes.Folder);
        String typeText = null;
        if (module.getType() == ModuleType.CORE_MODULE) {
            typeText = "Node.js core module";
        } else {
            String presentablePath = module.getPresentablePath(context2);
            if (presentablePath != null) {
                typeText = presentablePath;
            }
        }
        LookupElementBuilder lookupElementBuilder = element2 = element2.withTypeText(typeText, true);
        if (lookupElementBuilder == null) {
            NodeFileModulePsiReferenceBase.$$$reportNull$$$0(16);
        }
        return lookupElementBuilder;
    }

    protected CompletionModuleInfo @NotNull [] getModuleInfos(VirtualFile requester) {
        if (CompletionModuleInfo.EMPTY == null) {
            NodeFileModulePsiReferenceBase.$$$reportNull$$$0(17);
        }
        return CompletionModuleInfo.EMPTY;
    }

    @Nullable
    public VirtualFile getContainingFile() {
        VirtualFile vFile;
        PsiFile psiFile = this.getElement().getContainingFile();
        if (psiFile != null && (vFile = (psiFile = psiFile.getOriginalFile()).getVirtualFile()) != null && vFile.isValid()) {
            return vFile;
        }
        return null;
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray;
        PsiElement resolve2 = this.resolve();
        if (resolve2 != null) {
            ResolveResult[] resolveResultArray2 = new ResolveResult[1];
            resolveResultArray = resolveResultArray2;
            resolveResultArray2[0] = new PsiElementResolveResult(resolve2);
        } else {
            resolveResultArray = ResolveResult.EMPTY_ARRAY;
        }
        if (resolveResultArray == null) {
            NodeFileModulePsiReferenceBase.$$$reportNull$$$0(18);
        }
        return resolveResultArray;
    }

    @Nullable
    public PsiFileReference getLastFileReference() {
        return this;
    }

    @NotNull
    public String getRequiredModuleName() {
        String string = this.myRequiredModuleName;
        if (string == null) {
            NodeFileModulePsiReferenceBase.$$$reportNull$$$0(19);
        }
        return string;
    }

    public boolean isSoft() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 6, 10, 13, 16, 17, 18, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalOrModuleReferenceOwner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredModuleName";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/reference/NodeFileModulePsiReferenceBase";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newContent";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/reference/NodeFileModulePsiReferenceBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalModuleInProject";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "toLookupElements";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createLookupElement";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleInfos";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredModuleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCanonicalModuleInProject";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "toLookupElements";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createLookupElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 6, 10, 13, 16, 17, 18, 19 -> new IllegalStateException(string);
        };
    }
}

