/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.boilerplate;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.download.NodeJsDownloadableInterpreter;
import com.intellij.javascript.nodejs.npm.AvailablePackageVersions;
import com.intellij.javascript.nodejs.npm.NpmNodePackage;
import com.intellij.javascript.nodejs.npm.NpmPackageDescriptor;
import com.intellij.javascript.nodejs.npm.registry.NpmRegistryService;
import com.intellij.javascript.nodejs.packages.NodePackageUtil;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.text.SemVer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class NpxPackageDescriptor
extends NodePackageDescriptor {
    private static final String NPX = "npx";
    private static final String NPX_SPACE = "npx ";
    private final List<? extends NpxCommand> myCommands;

    NpxPackageDescriptor(@NotNull List<String> packageNames, @NotNull List<? extends NpxCommand> commands) {
        if (packageNames == null) {
            NpxPackageDescriptor.$$$reportNull$$$0(0);
        }
        if (commands == null) {
            NpxPackageDescriptor.$$$reportNull$$$0(1);
        }
        super(packageNames);
        this.myCommands = commands;
    }

    @Override
    @NotNull
    public List<NodePackage> listAvailable(@NotNull Project project, @Nullable NodeJsInterpreter interpreter2, @Nullable VirtualFile contextFileOrDirectory, boolean directDependenciesInsideProject) {
        if (project == null) {
            NpxPackageDescriptor.$$$reportNull$$$0(2);
        }
        ArrayList<NodePackage> results = new ArrayList<NodePackage>();
        if (interpreter2 instanceof NodeJsDownloadableInterpreter || NpxPackageDescriptor.getNpxBinaryFilePackage(interpreter2) != null) {
            for (NpxCommand npxCommand : this.myCommands) {
                results.add(npxCommand.createPackage());
            }
        }
        NodeJsInterpreter forSearchingGlobalPackages = !directDependenciesInsideProject ? interpreter2 : null;
        results.addAll(super.listAvailable(project, forSearchingGlobalPackages, contextFileOrDirectory, directDependenciesInsideProject));
        ArrayList<NodePackage> arrayList = results;
        if (arrayList == null) {
            NpxPackageDescriptor.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public NodePackage createPackage(@NotNull String path2) {
        if (path2 == null) {
            NpxPackageDescriptor.$$$reportNull$$$0(4);
        }
        if (path2.startsWith(NPX_SPACE)) {
            return new NpxNodePackage(path2.substring(NPX_SPACE.length()));
        }
        NodePackage nodePackage = super.createPackage(path2);
        if (nodePackage == null) {
            NpxPackageDescriptor.$$$reportNull$$$0(5);
        }
        return nodePackage;
    }

    @Nullable
    static NpxNodePackage createIfAvailable(@Nullable NodeJsInterpreter interpreter2, @NotNull NpxCommand command) {
        if (command == null) {
            NpxPackageDescriptor.$$$reportNull$$$0(6);
        }
        if (interpreter2 instanceof NodeJsDownloadableInterpreter || NpxPackageDescriptor.getNpxBinaryFilePackage(interpreter2) != null) {
            return command.createPackage();
        }
        return null;
    }

    @Nullable
    private static NpmNodePackage getNpxBinaryFilePackage(@Nullable NodeJsInterpreter interpreter2) {
        return NpmPackageDescriptor.findBinaryFilePackage(interpreter2, NPX);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageNames";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commands";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/boilerplate/NpxPackageDescriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/boilerplate/NpxPackageDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "listAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createPackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "listAvailable";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createPackage";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createIfAvailable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5 -> new IllegalStateException(string);
        };
    }

    public static class NpxCommand {
        private final String myPackageName;
        private final String myCommand;

        public NpxCommand(@NotNull String packageName, @NotNull String command) {
            if (packageName == null) {
                NpxCommand.$$$reportNull$$$0(0);
            }
            if (command == null) {
                NpxCommand.$$$reportNull$$$0(1);
            }
            this.myPackageName = packageName;
            this.myCommand = command;
        }

        @NotNull
        private NpxNodePackage createPackage() {
            if (this.myPackageName.equals(this.myCommand)) {
                return new NpxNodePackage(Collections.singletonList(this.myCommand));
            }
            return new NpxNodePackage(Arrays.asList("--package", this.myPackageName, this.myCommand));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "packageName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "command";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/boilerplate/NpxPackageDescriptor$NpxCommand";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class NpxNodePackage
    extends NodePackage {
        private static final Logger LOG = Logger.getInstance(NpxNodePackage.class);
        private final List<String> myArguments;

        NpxNodePackage(@NotNull List<String> arguments) {
            if (arguments == null) {
                NpxNodePackage.$$$reportNull$$$0(0);
            }
            this(ParametersListUtil.join(arguments));
        }

        NpxNodePackage(@NotNull String npxArguments) {
            if (npxArguments == null) {
                NpxNodePackage.$$$reportNull$$$0(1);
            }
            super(NpxPackageDescriptor.NPX_SPACE + npxArguments);
            this.myArguments = ParametersListUtil.parse((String)npxArguments);
        }

        @Nullable
        private static String getPackageWithSpecifier(@NotNull List<String> arguments) {
            int ind;
            if (arguments == null) {
                NpxNodePackage.$$$reportNull$$$0(2);
            }
            if ((ind = arguments.indexOf("--package")) >= 0 && ind + 1 < arguments.size()) {
                return arguments.get(ind + 1);
            }
            return (String)ContainerUtil.find(arguments, arg -> !arg.startsWith("-"));
        }

        @Nullable
        private static Pair<String, String> getPackageNameAndVersionRangePair(@NotNull List<String> arguments) {
            String arg;
            if (arguments == null) {
                NpxNodePackage.$$$reportNull$$$0(3);
            }
            if ((arg = NpxNodePackage.getPackageWithSpecifier(arguments)) == null) {
                return null;
            }
            int delimiterIndex = arg.lastIndexOf(64);
            if (delimiterIndex > 0) {
                return Pair.create((Object)arg.substring(0, delimiterIndex), (Object)arg.substring(delimiterIndex + 1));
            }
            return Pair.create((Object)arg, null);
        }

        @Override
        @NotNull
        public String getPresentablePath() {
            String string = this.getSystemIndependentPath();
            if (string == null) {
                NpxNodePackage.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        @NotNull
        public Promise<SemVer> getVersionPromise(@Nullable Project project) {
            String packageName;
            Pair<String, String> packageNameAndVersionRangePair = NpxNodePackage.getPackageNameAndVersionRangePair(this.myArguments);
            String string = packageName = packageNameAndVersionRangePair != null ? (String)packageNameAndVersionRangePair.first : null;
            if (packageName == null) {
                Promise promise = Promises.resolvedPromise(null);
                if (promise == null) {
                    NpxNodePackage.$$$reportNull$$$0(5);
                }
                return promise;
            }
            if (NodePackageUtil.validateNpmPackageName(packageName) != null) {
                Promise promise = Promises.resolvedPromise(null);
                if (promise == null) {
                    NpxNodePackage.$$$reportNull$$$0(6);
                }
                return promise;
            }
            NpmRegistryService npmRegistryService = NpmRegistryService.getInstance(project != null ? project : ProjectManager.getInstance().getDefaultProject());
            CompletableFuture<AvailablePackageVersions> future = npmRegistryService.getCachedOrFetchPackageVersionsFuture(packageName, null);
            AvailablePackageVersions immediateVersions = future.getNow(null);
            String versionRangeOrDistTag = Objects.requireNonNullElse(StringUtil.nullize((String)((String)packageNameAndVersionRangePair.second), (boolean)true), "latest");
            if (immediateVersions != null) {
                Promise promise = Promises.resolvedPromise((Object)immediateVersions.findMatchedVersion(versionRangeOrDistTag));
                if (promise == null) {
                    NpxNodePackage.$$$reportNull$$$0(7);
                }
                return promise;
            }
            Promise promise = Promises.asPromise((CompletableFuture)future.thenApply(versions -> versions != null ? versions.findMatchedVersion(versionRangeOrDistTag) : null));
            if (promise == null) {
                NpxNodePackage.$$$reportNull$$$0(8);
            }
            return promise;
        }

        @Override
        public boolean isValid(@Nullable Project project, @Nullable NodeJsInterpreter interpreter2) {
            return !this.myArguments.isEmpty();
        }

        @Override
        @Nullable
        public String validateAndGetErrorMessage(@NotNull String packageName, @Nullable Project project, @Nullable NodeJsInterpreter interpreter2) {
            if (packageName == null) {
                NpxNodePackage.$$$reportNull$$$0(9);
            }
            return this.isValid(project, interpreter2) ? null : JavaScriptBundle.message((String)"dialog.message.invalid.npx.command", (Object[])new Object[0]);
        }

        @NotNull
        public NpmNodePackage getNpxBinaryFilePackageOrThrow(@NotNull NodeJsInterpreter interpreter2) throws com.intellij.execution.ExecutionException {
            NpmNodePackage npxPkg;
            if (interpreter2 == null) {
                NpxNodePackage.$$$reportNull$$$0(10);
            }
            if ((npxPkg = NpxPackageDescriptor.getNpxBinaryFilePackage(interpreter2)) != null) {
                NpmNodePackage npmNodePackage = npxPkg;
                if (npmNodePackage == null) {
                    NpxNodePackage.$$$reportNull$$$0(11);
                }
                return npmNodePackage;
            }
            throw new com.intellij.execution.ExecutionException(NpxNodePackage.getNpxNotFoundErrorMessage(interpreter2));
        }

        @NotNull
        public List<String> blockingGetArguments(@NotNull NodeJsInterpreter interpreter2) throws com.intellij.execution.ExecutionException {
            List list;
            if (interpreter2 == null) {
                NpxNodePackage.$$$reportNull$$$0(12);
            }
            long startNano = System.nanoTime();
            Promise<List<String>> npxArgs = this.getArguments(interpreter2);
            try {
                List list2 = Objects.requireNonNull((List)npxArgs.blockingGet(5, TimeUnit.SECONDS));
                list = list2;
            }
            catch (ExecutionException | TimeoutException e) {
                throw new com.intellij.execution.ExecutionException((Throwable)e);
            }
            finally {
                LOG.info("Blocking loading Node.js version took " + TimeoutUtil.getDurationMillis((long)startNano) + " ms");
            }
            if (list == null) {
                NpxNodePackage.$$$reportNull$$$0(13);
            }
            return list;
        }

        @NotNull
        private Promise<List<String>> getArguments(@NotNull NodeJsInterpreter interpreter2) {
            if (interpreter2 == null) {
                NpxNodePackage.$$$reportNull$$$0(14);
            }
            Promise promise = NpxNodePackage.isNpm7orLater(interpreter2).then(isNpm7orLater -> {
                if (Boolean.TRUE.equals(isNpm7orLater)) {
                    return ContainerUtil.concat(List.of("--yes"), NpxNodePackage.addLatestTagIfNeeded(this.myArguments));
                }
                return ContainerUtil.concat(List.of("--ignore-existing"), NpxNodePackage.addLatestTagIfNeeded(this.myArguments));
            });
            if (promise == null) {
                NpxNodePackage.$$$reportNull$$$0(15);
            }
            return promise;
        }

        @NotNull
        private static List<String> addLatestTagIfNeeded(List<String> arguments) {
            int ind = arguments.indexOf("--package") + 1;
            if ((ind <= 0 || ind >= arguments.size()) && (ind = ContainerUtil.indexOf(arguments, arg -> !arg.startsWith("-"))) < 0) {
                List<String> list = arguments;
                if (list == null) {
                    NpxNodePackage.$$$reportNull$$$0(16);
                }
                return list;
            }
            Object packageName = arguments.get(ind);
            if (((String)packageName).lastIndexOf(64) <= 0) {
                packageName = (String)packageName + "@latest";
                List list = ContainerUtil.concat((List[])new List[]{arguments.subList(0, ind), Collections.singletonList(packageName), arguments.subList(ind + 1, arguments.size())});
                if (list == null) {
                    NpxNodePackage.$$$reportNull$$$0(17);
                }
                return list;
            }
            List<String> list = arguments;
            if (list == null) {
                NpxNodePackage.$$$reportNull$$$0(18);
            }
            return list;
        }

        @NotNull
        private static Promise<Boolean> isNpm7orLater(@NotNull NodeJsInterpreter interpreter2) {
            if (interpreter2 == null) {
                NpxNodePackage.$$$reportNull$$$0(19);
            }
            Promise promise = interpreter2.provideCachedVersionOrFetch().then(interpreterVersion -> interpreterVersion == null || interpreterVersion.isGreaterOrEqualThan(15, 0, 0));
            if (promise == null) {
                NpxNodePackage.$$$reportNull$$$0(20);
            }
            return promise;
        }

        @NlsContexts.DialogMessage
        @NotNull
        private static String getNpxNotFoundErrorMessage(@NotNull NodeJsInterpreter interpreter2) {
            if (interpreter2 == null) {
                NpxNodePackage.$$$reportNull$$$0(21);
            }
            String string = JavaScriptBundle.message((String)"dialog.message.cannot.find.npx.bundled.with", (Object[])new Object[]{interpreter2.getPresentableName()});
            if (string == null) {
                NpxNodePackage.$$$reportNull$$$0(22);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5, 6, 7, 8, 11, 13, 15, 16, 17, 18, 20, 22 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arguments";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "npxArguments";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 11: 
                case 13: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 20: 
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/boilerplate/NpxPackageDescriptor$NpxNodePackage";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageName";
                    break;
                }
                case 10: 
                case 12: 
                case 14: 
                case 19: 
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interpreter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/boilerplate/NpxPackageDescriptor$NpxNodePackage";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentablePath";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVersionPromise";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNpxBinaryFilePackageOrThrow";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "blockingGetArguments";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArguments";
                    break;
                }
                case 16: 
                case 17: 
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addLatestTagIfNeeded";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "isNpm7orLater";
                    break;
                }
                case 22: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNpxNotFoundErrorMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getPackageWithSpecifier";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getPackageNameAndVersionRangePair";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 11: 
                case 13: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 20: 
                case 22: {
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "validateAndGetErrorMessage";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getNpxBinaryFilePackageOrThrow";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "blockingGetArguments";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "getArguments";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "isNpm7orLater";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "getNpxNotFoundErrorMessage";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5, 6, 7, 8, 11, 13, 15, 16, 17, 18, 20, 22 -> new IllegalStateException(string);
            };
        }
    }
}

