/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.config;

import com.intellij.lang.javascript.config.JSFileImportsResolver;
import com.intellij.lang.javascript.config.JSFileInclude;
import com.intellij.lang.javascript.config.JSImportResolveContext;
import com.intellij.lang.javascript.config.graph.JSConfigGraphCache;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSSimpleFileInclude
implements JSFileInclude {
    @NotNull
    protected final VirtualFile myFile;
    @Nullable
    protected final VirtualFile myTypesRoot;
    @NotNull
    private final JSFileImportsResolver myResolver;
    @NotNull
    private final JSImportResolveContext myContext;

    public JSSimpleFileInclude(@NotNull VirtualFile file, @NotNull JSFileImportsResolver resolver, @Nullable VirtualFile typesRoot, @NotNull JSImportResolveContext context2) {
        if (file == null) {
            JSSimpleFileInclude.$$$reportNull$$$0(0);
        }
        if (resolver == null) {
            JSSimpleFileInclude.$$$reportNull$$$0(1);
        }
        if (context2 == null) {
            JSSimpleFileInclude.$$$reportNull$$$0(2);
        }
        this.myFile = file;
        this.myResolver = resolver;
        this.myTypesRoot = typesRoot;
        this.myContext = context2;
    }

    public boolean accept(@NotNull VirtualFile file) {
        if (file == null) {
            JSSimpleFileInclude.$$$reportNull$$$0(3);
        }
        return this.myFile.equals(file) || this.myTypesRoot != null && VfsUtilCore.isAncestor((VirtualFile)this.myTypesRoot, (VirtualFile)file, (boolean)true);
    }

    @NotNull
    public GlobalSearchScope getRootScope(@NotNull Project project) {
        if (project == null) {
            JSSimpleFileInclude.$$$reportNull$$$0(4);
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
        if (globalSearchScope == null) {
            JSSimpleFileInclude.$$$reportNull$$$0(5);
        }
        return globalSearchScope;
    }

    @NotNull
    public Set<VirtualFile> getAdditionalRootFiles(@NotNull Project project) {
        if (project == null) {
            JSSimpleFileInclude.$$$reportNull$$$0(6);
        }
        if (this.myTypesRoot == null) {
            Set<VirtualFile> set = Collections.singleton(this.myFile);
            if (set == null) {
                JSSimpleFileInclude.$$$reportNull$$$0(7);
            }
            return set;
        }
        Set<VirtualFile> files = JSConfigGraphCache.getService(project).getTypesFiles(this.myTypesRoot);
        if (files.isEmpty()) {
            Set<VirtualFile> set = Collections.singleton(this.myFile);
            if (set == null) {
                JSSimpleFileInclude.$$$reportNull$$$0(8);
            }
            return set;
        }
        HashSet<VirtualFile> result2 = new HashSet<VirtualFile>();
        result2.add(this.myFile);
        result2.addAll(files);
        HashSet<VirtualFile> hashSet = result2;
        if (hashSet == null) {
            JSSimpleFileInclude.$$$reportNull$$$0(9);
        }
        return hashSet;
    }

    @NotNull
    public JSFileImportsResolver getImportResolver() {
        JSFileImportsResolver jSFileImportsResolver = this.myResolver;
        if (jSFileImportsResolver == null) {
            JSSimpleFileInclude.$$$reportNull$$$0(10);
        }
        return jSFileImportsResolver;
    }

    @NotNull
    public JSImportResolveContext getResolveContext() {
        JSImportResolveContext jSImportResolveContext = this.myContext;
        if (jSImportResolveContext == null) {
            JSSimpleFileInclude.$$$reportNull$$$0(11);
        }
        return jSImportResolveContext;
    }

    public int hashCode() {
        return Objects.hash(this.myFile);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSSimpleFileInclude include = (JSSimpleFileInclude)o;
        return this.myFile.equals(include.myFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7, 8, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/config/JSSimpleFileInclude";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/config/JSSimpleFileInclude";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootScope";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalRootFiles";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportResolver";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRootScope";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalRootFiles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7, 8, 9, 10, 11 -> new IllegalStateException(string);
        };
    }
}

