/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspection;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.inspection.JSSuspiciousInstanceofCheck;
import com.intellij.lang.javascript.inspection.JSSuspiciousTypeOfCheck;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardChecker;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSSuspiciousTypeGuardInspection
extends JSInspection {
    @Override
    @NotNull
    public String getShortName() {
        return "SuspiciousTypeOfGuard";
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSSuspiciousTypeGuardInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSSuspiciousTypeGuardInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            public void visitJSBinaryExpression(@NotNull JSBinaryExpression expression) {
                IElementType sign;
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((sign = expression.getOperationSign()) == JSTokenTypes.INSTANCEOF_KEYWORD) {
                    JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)expression, () -> JSSuspiciousInstanceofCheck.checkInstanceOfGuard(holder, expression, JSSuspiciousTypeGuardInspection.this.getProblemHighlighter()));
                    return;
                }
                if (!JSSuspiciousTypeGuardInspection.isEqualityLikeSign(sign)) {
                    return;
                }
                JSExpression left = JSTypeGuardUtil.getReferenceCandidate((JSExpression)expression.getLOperand());
                JSExpression right = JSTypeGuardUtil.getReferenceCandidate((JSExpression)expression.getROperand());
                if (left == null || right == null) {
                    return;
                }
                JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)expression, () -> {
                    JSPrefixExpression rightTypeOf;
                    JSPrefixExpression leftTypeOf = JSTypeGuardChecker.getTypeOfPrefixExpression((JSExpression)left);
                    if (leftTypeOf != null && JSTypeGuardChecker.isStringLiteralExpression((JSExpression)right)) {
                        JSSuspiciousTypeOfCheck.checkTypeofGuard(holder, expression, leftTypeOf, (JSLiteralExpression)right, sign, JSSuspiciousTypeGuardInspection.this.getProblemHighlighter());
                    }
                    if ((rightTypeOf = JSTypeGuardChecker.getTypeOfPrefixExpression((JSExpression)right)) != null && JSTypeGuardChecker.isStringLiteralExpression((JSExpression)left)) {
                        JSSuspiciousTypeOfCheck.checkTypeofGuard(holder, expression, rightTypeOf, (JSLiteralExpression)left, sign, JSSuspiciousTypeGuardInspection.this.getProblemHighlighter());
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/inspection/JSSuspiciousTypeGuardInspection$1", "visitJSBinaryExpression"));
            }
        };
    }

    @NotNull
    protected ProblemHighlightType getProblemHighlighter() {
        ProblemHighlightType problemHighlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
        if (problemHighlightType == null) {
            JSSuspiciousTypeGuardInspection.$$$reportNull$$$0(2);
        }
        return problemHighlightType;
    }

    @Contract(value="null->false")
    private static boolean isEqualityLikeSign(@Nullable IElementType sign) {
        return sign == JSTokenTypes.EQEQ || sign == JSTokenTypes.NE || sign == JSTokenTypes.NEQEQ || sign == JSTokenTypes.EQEQEQ;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspection/JSSuspiciousTypeGuardInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspection/JSSuspiciousTypeGuardInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProblemHighlighter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

