/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.openapi.project.BaseProjectDirectories;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.GlobUtilKt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;

public final class GlobPatternUtil {
    private GlobPatternUtil() {
    }

    public static boolean isFileMatchingGlobPattern(@NotNull Project project, @NotNull String pattern, @NotNull VirtualFile file) {
        List<VirtualFile> files;
        if (project == null) {
            GlobPatternUtil.$$$reportNull$$$0(0);
        }
        if (pattern == null) {
            GlobPatternUtil.$$$reportNull$$$0(1);
        }
        if (file == null) {
            GlobPatternUtil.$$$reportNull$$$0(2);
        }
        return (files = GlobPatternUtil.filterFilesMatchingGlobPattern(project, pattern, Collections.singletonList(file))).size() == 1 && file.equals(files.getFirst());
    }

    @NotNull
    private static String getPathToMatch(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            GlobPatternUtil.$$$reportNull$$$0(3);
        }
        if (file == null) {
            GlobPatternUtil.$$$reportNull$$$0(4);
        }
        String path2 = file.getPath();
        String basePath = project.getBasePath();
        if (basePath != null && path2.startsWith(basePath + "/")) {
            String string = path2.substring(basePath.length() + 1);
            if (string == null) {
                GlobPatternUtil.$$$reportNull$$$0(5);
            }
            return string;
        }
        VirtualFile baseDirectory = BaseProjectDirectories.getInstance((Project)project).getBaseDirectoryFor(file);
        if (baseDirectory != null && path2.startsWith(baseDirectory.getPath() + "/")) {
            String string = path2.substring(baseDirectory.getPath().length() + 1);
            if (string == null) {
                GlobPatternUtil.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = path2;
        if (string == null) {
            GlobPatternUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public static List<VirtualFile> filterFilesMatchingGlobPattern(@NotNull Project project, @NotNull String globPattern, @NotNull List<VirtualFile> files) {
        List list;
        if (project == null) {
            GlobPatternUtil.$$$reportNull$$$0(8);
        }
        if (globPattern == null) {
            GlobPatternUtil.$$$reportNull$$$0(9);
        }
        if (files == null) {
            GlobPatternUtil.$$$reportNull$$$0(10);
        }
        try {
            PathMatcher matcher = GlobUtilKt.getPathMatcher((String)globPattern, (boolean)false);
            list = ContainerUtil.mapNotNull(files, file -> {
                if (file != null && file.isInLocalFileSystem() && matcher.matches(Paths.get(GlobPatternUtil.getPathToMatch(project, file), new String[0]))) {
                    return file;
                }
                return null;
            });
        }
        catch (PatternSyntaxException ignore) {
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                GlobPatternUtil.$$$reportNull$$$0(12);
            }
            return list2;
        }
        if (list == null) {
            GlobPatternUtil.$$$reportNull$$$0(11);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/GlobPatternUtil";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globPattern";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/GlobPatternUtil";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathToMatch";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "filterFilesMatchingGlobPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isFileMatchingGlobPattern";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPathToMatch";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "filterFilesMatchingGlobPattern";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 11, 12 -> new IllegalStateException(string);
        };
    }
}

