/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.index.JSIndexedRootProvider;
import com.intellij.lang.javascript.library.JSLibraryKind;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.lang.javascript.library.JSPredefinedLibraryManager;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveScopeProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IndexableSetContributor;
import com.intellij.webcore.libraries.ScriptingLibraryManager;
import com.intellij.webcore.libraries.ScriptingLibraryUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class JSResolveScopeProvider
extends ResolveScopeProvider {
    private static final Key<ProjectScopeWrapper> PROJECT_SCOPE_WITH_LANGUAGE_SPECIFIC_PREDEFINED_KEY = Key.create((String)"js.project.scope.with.predefined.language.specific");

    @NotNull
    public final GlobalSearchScope getProjectScopeIncludingPredefines(@NotNull Project project) {
        Class<?> aClass;
        GlobalSearchScope scope2;
        ProjectScopeWrapper wrapper;
        if (project == null) {
            JSResolveScopeProvider.$$$reportNull$$$0(0);
        }
        if ((wrapper = (ProjectScopeWrapper)project.getUserData(PROJECT_SCOPE_WITH_LANGUAGE_SPECIFIC_PREDEFINED_KEY)) == null || !wrapper.isUpToDate()) {
            wrapper = new ProjectScopeWrapper(project);
            project.putUserData(PROJECT_SCOPE_WITH_LANGUAGE_SPECIFIC_PREDEFINED_KEY, (Object)wrapper);
        }
        if ((scope2 = wrapper.myScopeByClassMap.get(aClass = ((Object)((Object)this)).getClass())) == null) {
            List<VirtualFile> predefinedLibraryFiles = this.getPredefinedLibraryFiles(project);
            scope2 = GlobalSearchScope.filesScope((Project)project, predefinedLibraryFiles).uniteWith(GlobalSearchScope.allScope((Project)project));
            wrapper.myScopeByClassMap.put(aClass, scope2);
        }
        GlobalSearchScope globalSearchScope = scope2;
        if (globalSearchScope == null) {
            JSResolveScopeProvider.$$$reportNull$$$0(1);
        }
        return globalSearchScope;
    }

    @NotNull
    protected GlobalSearchScope getProjectAndLibrariesScope(@NotNull VirtualFile file, @NotNull Project project, @NotNull Set<VirtualFile> includedFiles, @NotNull Set<VirtualFile> excludedFiles) {
        Module module;
        if (file == null) {
            JSResolveScopeProvider.$$$reportNull$$$0(2);
        }
        if (project == null) {
            JSResolveScopeProvider.$$$reportNull$$$0(3);
        }
        if (includedFiles == null) {
            JSResolveScopeProvider.$$$reportNull$$$0(4);
        }
        if (excludedFiles == null) {
            JSResolveScopeProvider.$$$reportNull$$$0(5);
        }
        GlobalSearchScope scopeExcludingJsLibs = (module = ProjectRootManager.getInstance((Project)project).getFileIndex().getModuleForFile(file)) != null ? JSResolveScopeProvider.getScopeExcludingJsLibs(module) : GlobalSearchScope.allScope((Project)project);
        GlobalSearchScope libraryFilesScope = JSLibraryMappings.getInstance(project).getLibraryScopeForFileWithoutPredefined(file, includedFiles, excludedFiles);
        GlobalSearchScope globalSearchScope = scopeExcludingJsLibs.uniteWith(libraryFilesScope);
        if (globalSearchScope == null) {
            JSResolveScopeProvider.$$$reportNull$$$0(6);
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope getScopeExcludingJsLibs(@NotNull Module module) {
        if (module == null) {
            JSResolveScopeProvider.$$$reportNull$$$0(7);
        }
        Project project = module.getProject();
        GlobalSearchScope globalSearchScope = (GlobalSearchScope)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)module, () -> {
            GlobalSearchScope allLibFiles = ScriptingLibraryUtil.getFilesAndDirectoriesScope((Project)project, (Collection)((JSIndexedRootProvider)((Object)((Object)IndexableSetContributor.EP_NAME.findExtension(JSIndexedRootProvider.class)))).getLibraryFiles(project));
            GlobalSearchScope moduleContentScope = module.getModuleContentWithDependenciesScope();
            GlobalSearchScope moduleWithDependenciesAndLibrariesScope = module.getModuleWithDependenciesAndLibrariesScope(true);
            GlobalSearchScope result2 = moduleContentScope.uniteWith(moduleWithDependenciesAndLibrariesScope).intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)allLibFiles));
            return new CachedValueProvider.Result((Object)result2, new Object[]{ProjectRootManager.getInstance((Project)project)});
        });
        if (globalSearchScope == null) {
            JSResolveScopeProvider.$$$reportNull$$$0(8);
        }
        return globalSearchScope;
    }

    protected @Unmodifiable @NotNull List<VirtualFile> getPredefinedLibraryFiles(@NotNull Project project) {
        if (project == null) {
            JSResolveScopeProvider.$$$reportNull$$$0(9);
        }
        HashSet<VirtualFile> libFiles = new HashSet<VirtualFile>();
        libFiles.addAll(ScriptingLibraryManager.getAllLibraryFiles((Project)project, JSLibraryKind.INSTANCE));
        libFiles.addAll(JSPredefinedLibraryManager.getPredefinedLibraryManager(project).getPredefinedLibraryFilesForResolve());
        List list = ContainerUtil.filter(libFiles, this::isApplicablePredefinedLibraryFile);
        if (list == null) {
            JSResolveScopeProvider.$$$reportNull$$$0(10);
        }
        return list;
    }

    protected abstract boolean isApplicablePredefinedLibraryFile(@NotNull VirtualFile var1);

    @Deprecated
    @Nullable
    public static VirtualFile getFileForScopeEvaluation(@NotNull PsiElement element2) {
        if (element2 == null) {
            JSResolveScopeProvider.$$$reportNull$$$0(11);
        }
        return JSResolveUtil.getFileForScopeEvaluation((PsiElement)element2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 6, 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSResolveScopeProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includedFiles";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedFiles";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSResolveScopeProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectScopeIncludingPredefines";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectAndLibrariesScope";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeExcludingJsLibs";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedLibraryFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProjectScopeIncludingPredefines";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 10: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getProjectAndLibrariesScope";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getScopeExcludingJsLibs";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPredefinedLibraryFiles";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getFileForScopeEvaluation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 6, 8, 10 -> new IllegalStateException(string);
        };
    }

    private static final class ProjectScopeWrapper {
        private final ModificationTracker myTracker;
        private final Map<Class<?>, GlobalSearchScope> myScopeByClassMap;
        private final long myCreationModCount;

        private ProjectScopeWrapper(@NotNull Project project) {
            if (project == null) {
                ProjectScopeWrapper.$$$reportNull$$$0(0);
            }
            this.myScopeByClassMap = new ConcurrentHashMap();
            this.myTracker = ProjectRootManager.getInstance((Project)project);
            this.myCreationModCount = this.myTracker.getModificationCount();
        }

        public boolean isUpToDate() {
            return this.myCreationModCount == this.myTracker.getModificationCount();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/psi/resolve/JSResolveScopeProvider$ProjectScopeWrapper", "<init>"));
        }
    }
}

