/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSInheritedLanguagesHelper;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;

public final class NonBlockStatementBodyJSInspection
extends JavaScriptInspection {
    private final InspectionJSFix fix = new WrapBodyFix();

    @Override
    @InspectionMessage
    @NotNull
    public String buildErrorString(Object ... args) {
        if (args[0] instanceof JSIfStatement) {
            String string = InspectionJSBundle.message("non.block.branch.error.string", new Object[0]);
            if (string == null) {
                NonBlockStatementBodyJSInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = InspectionJSBundle.message("non.block.body.error.string", new Object[0]);
        if (string == null) {
            NonBlockStatementBodyJSInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public InspectionJSFix buildFix(PsiElement location) {
        return this.fix;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/style/NonBlockStatementBodyJSInspection", "buildErrorString"));
    }

    private static class WrapBodyFix
    extends InspectionJSFix {
        private WrapBodyFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionJSBundle.message("wrap.statement.body.fix", new Object[0]);
            if (string == null) {
                WrapBodyFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement statementIdentifier = descriptor.getPsiElement();
            JSStatement statement = (JSStatement)statementIdentifier.getParent();
            if (statement instanceof JSLoopStatement) {
                JSStatement body = ((JSLoopStatement)statement).getBody();
                WrapBodyFix.wrapStatement(body);
            } else {
                JSStatement elseBranch;
                JSIfStatement ifStatement = (JSIfStatement)statement;
                JSStatement thenBranch = (JSStatement)ifStatement.getThenBranch();
                if (thenBranch != null && !(thenBranch instanceof JSBlockStatement)) {
                    WrapBodyFix.wrapStatement(thenBranch);
                }
                if ((elseBranch = (JSStatement)ifStatement.getElseBranch()) != null && !(elseBranch instanceof JSBlockStatement)) {
                    WrapBodyFix.wrapStatement(elseBranch);
                }
            }
        }

        private static void wrapStatement(JSStatement statement) throws IncorrectOperationException {
            String text = statement.getText();
            WrapBodyFix.replaceStatement(statement, "{" + text + "}");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/style/NonBlockStatementBodyJSInspection$WrapBodyFix", "getFamilyName"));
        }
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSDoWhileStatement(@NotNull JSDoWhileStatement statement) {
            if (statement == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitJSDoWhileStatement(statement);
            JSStatement body = statement.getBody();
            if (body == null) {
                return;
            }
            if (body instanceof JSBlockStatement) {
                return;
            }
            this.registerStatementError((JSSourceElement)statement, statement);
        }

        public void visitJSWhileStatement(@NotNull JSWhileStatement statement) {
            if (statement == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            super.visitJSWhileStatement(statement);
            JSStatement body = statement.getBody();
            if (body == null) {
                return;
            }
            if (body instanceof JSBlockStatement) {
                return;
            }
            this.registerStatementError((JSSourceElement)statement, statement);
        }

        public void visitJSForStatement(@NotNull JSForStatement statement) {
            if (statement == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            super.visitJSForStatement(statement);
            JSStatement body = statement.getBody();
            if (body == null) {
                return;
            }
            if (body instanceof JSBlockStatement) {
                return;
            }
            this.registerStatementError((JSSourceElement)statement, statement);
        }

        public void visitJSForInStatement(@NotNull JSForInStatement statement) {
            if (statement == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            super.visitJSForInStatement(statement);
            JSStatement body = statement.getBody();
            if (body == null) {
                return;
            }
            if (body instanceof JSBlockStatement) {
                return;
            }
            this.registerStatementError((JSSourceElement)statement, statement);
        }

        public void visitJSIfStatement(@NotNull JSIfStatement statement) {
            if (statement == null) {
                Visitor.$$$reportNull$$$0(4);
            }
            super.visitJSIfStatement(statement);
            JSStatement thenBranch = (JSStatement)statement.getThenBranch();
            if (thenBranch != null && !(thenBranch instanceof JSBlockStatement) && !JSInheritedLanguagesHelper.skipNonBlockBranch((PsiElement)thenBranch)) {
                this.registerStatementError((JSSourceElement)statement, statement);
                return;
            }
            JSStatement elseBranch = (JSStatement)statement.getElseBranch();
            if (elseBranch != null && !(elseBranch instanceof JSBlockStatement) && !(elseBranch instanceof JSIfStatement)) {
                this.registerStatementError((JSSourceElement)statement, statement);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "statement";
            objectArray2[1] = "com/sixrr/inspectjs/style/NonBlockStatementBodyJSInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSDoWhileStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSWhileStatement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSForStatement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSForInStatement";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSIfStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

