/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.jfr.jmc;

import com.intellij.openapi.util.Predicates;
import com.intellij.profiler.ultimate.jfr.jmc.EventCountInfo;
import com.intellij.profiler.ultimate.jfr.jmc.EventTypeFolderNode;
import com.intellij.profiler.ultimate.jfr.jmc.ItemCollectionToolkit;
import com.intellij.profiler.ultimate.jfr.jmc.ItemIterableToolkit;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.IItemIterable;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.util.PredicateToolkit;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.internal.EventArray;

public class StreamModel {
    private final EventArray[] eventsByType;
    private final Map<String, Long> realEventsCount = new HashMap<String, Long>();

    public StreamModel(EventArray[] eventsByType) {
        this.eventsByType = eventsByType;
    }

    public void setRealEventCount(String eventTypeIdentifier, long count) {
        this.realEventsCount.put(eventTypeIdentifier, count);
    }

    public IItemCollection getItems(IRange<IQuantity> range, IItemFilter filter) {
        IItemIterable[] rangedStreams = (IItemIterable[])Stream.of(this.eventsByType).map(ea -> {
            IType<IItem> eventType = ea.getType();
            Predicate<IItem> predicate = filter.getPredicate(eventType);
            if (PredicateToolkit.isTrueGuaranteed(predicate)) {
                return ItemIterableToolkit.build(StreamModel.itemSupplier(ea.getEvents(), eventType, range), eventType);
            }
            if (PredicateToolkit.isFalseGuaranteed(predicate)) {
                return null;
            }
            return ItemIterableToolkit.build(StreamModel.itemSupplier(ea.getEvents(), eventType, range, predicate), eventType);
        }).filter(Predicates.nonNull()).toArray(IItemIterable[]::new);
        return ItemCollectionToolkit.build(() -> Arrays.stream(rangedStreams));
    }

    public IItemCollection getItems(IRange<IQuantity> range) {
        return ItemCollectionToolkit.build(() -> Arrays.stream(this.eventsByType).map(ea -> ItemIterableToolkit.build(() -> StreamModel.itemSupplier(ea.getEvents(), ea.getType(), range).get(), ea.getType())));
    }

    public IItemCollection getItems() {
        return ItemCollectionToolkit.build(() -> Arrays.stream(this.eventsByType).map(ea -> ItemIterableToolkit.build(() -> Arrays.stream(ea.getEvents()), ea.getType())));
    }

    private static Supplier<Stream<IItem>> itemSupplier(IItem[] events, IType<IItem> ofType, IRange<IQuantity> range) {
        int start2 = StreamModel.findStart(events, ofType, range.getStart());
        int end = StreamModel.findEnd(events, ofType, range.getEnd());
        return () -> Arrays.stream(events, start2, end);
    }

    private static Supplier<Stream<IItem>> itemSupplier(IItem[] events, IType<IItem> ofType, IRange<IQuantity> range, Predicate<? super IItem> predicate) {
        int start2 = StreamModel.findStart(events, ofType, range.getStart());
        int end = StreamModel.findEnd(events, ofType, range.getEnd());
        return () -> Arrays.stream(events, start2, end).filter(predicate);
    }

    private static int findStart(IItem[] events, IType<IItem> ofType, IQuantity boundary) {
        int index;
        IMemberAccessor<IQuantity, IItem> accessor = JfrAttributes.END_TIME.getAccessor(ofType);
        for (index = StreamModel.binarySearch(events, accessor, boundary); index > 0 && accessor.getMember(events[index - 1]).compareTo(boundary) == 0; --index) {
        }
        return index;
    }

    private static int findEnd(IItem[] events, IType<IItem> ofType, IQuantity boundary) {
        int index;
        IMemberAccessor<IQuantity, IItem> accessor = JfrAttributes.START_TIME.getAccessor(ofType);
        for (index = StreamModel.binarySearch(events, accessor, boundary); index < events.length && accessor.getMember(events[index]).compareTo(boundary) == 0; ++index) {
        }
        return index;
    }

    private static int binarySearch(IItem[] events, IMemberAccessor<IQuantity, IItem> accessor, IQuantity key) {
        int low = 0;
        int high = events.length - 1;
        while (low <= high) {
            int middle = low + high >>> 1;
            int comparison = key.compareTo(accessor.getMember(events[middle]));
            if (comparison == 0) {
                return middle;
            }
            if (comparison > 0) {
                low = middle + 1;
                continue;
            }
            high = middle - 1;
        }
        return low;
    }

    public EventTypeFolderNode getTypeTree(Stream<IItemIterable> items) {
        Map<IType, Long> itemCountByType = items.collect(Collectors.toMap(IItemIterable::getType, is -> is.getItemCount(), Long::sum));
        Function<EventArray, EventTypeFolderNode.TypeWithCategory> eventArrayToTypeWithCategoryMapper = ea -> {
            Long count = (Long)itemCountByType.remove(ea.getType());
            return count == null ? null : this.buildType((EventArray)ea, count);
        };
        return EventTypeFolderNode.buildRoot(Stream.of(this.eventsByType).map(eventArrayToTypeWithCategoryMapper).filter(Predicates.nonNull()));
    }

    private EventTypeFolderNode.TypeWithCategory buildType(EventArray ea, long count) {
        IType<IItem> type = ea.getType();
        long realCount = this.realEventsCount.getOrDefault(type.getIdentifier(), count);
        EventCountInfo eventCountInfo = new EventCountInfo(count, realCount);
        return new EventTypeFolderNode.TypeWithCategory(type, ea.getTypeCategory(), eventCountInfo);
    }

    public EventTypeFolderNode getTypeTree() {
        return this.getTypeTree(ItemCollectionToolkit.stream(this.getItems()));
    }
}

