/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.internal.parser.v0;

import org.openjdk.jmc.flightrecorder.internal.InvalidJfrFileException;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.IArrayElementParser;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.NumberReaders;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.Offset;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.UTFStringParser;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.model.ContentTypeDescriptor;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.model.DataStructure;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.model.DataType;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.model.ValueDescriptor;
import org.openjdk.jmc.flightrecorder.internal.util.ParserToolkit;
import org.openjdk.jmc.flightrecorder.parser.ByteBufferWrapper;

final class ContentTypeParser
implements IArrayElementParser<ContentTypeDescriptor> {
    private final DataStructure[] dataStructures;

    public ContentTypeParser(DataStructure[] dataStructures) {
        this.dataStructures = dataStructures;
    }

    @Override
    public ContentTypeDescriptor readElement(ByteBufferWrapper data2, Offset offset) throws InvalidJfrFileException {
        int constantPoolIndex = NumberReaders.readInt(data2, offset);
        String name = UTFStringParser.readString(data2, offset);
        String description = UTFStringParser.readString(data2, offset);
        DataType dataType = ParserToolkit.get(DataType.values(), NumberReaders.readByte(data2, offset));
        ValueDescriptor[] dataStructure = ParserToolkit.get(this.dataStructures, NumberReaders.readInt(data2, offset)).getValueDescriptors();
        return new ContentTypeDescriptor(constantPoolIndex, name, description, dataType, dataStructure);
    }

    public ContentTypeDescriptor[] createArray(int length) {
        return new ContentTypeDescriptor[length];
    }
}

