/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.appServers.deployment;

import com.intellij.javaee.appServers.customDeployment.CustomDeploymentProvider;
import com.intellij.javaee.appServers.deployment.DeploymentMethod;
import com.intellij.javaee.appServers.deployment.DeploymentModel;
import com.intellij.javaee.appServers.deployment.DeploymentSource;
import com.intellij.javaee.appServers.deployment.ExternalFileDeploymentProvider;
import com.intellij.javaee.appServers.deployment.JavaeeDeploymentUtil;
import com.intellij.javaee.appServers.run.configuration.CommonModel;
import com.intellij.javaee.appServers.serverInstances.J2EEServerInstance;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.ArtifactType;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public abstract class DeploymentProvider {
    public abstract void doDeploy(Project var1, J2EEServerInstance var2, DeploymentModel var3);

    public abstract void startUndeploy(J2EEServerInstance var1, DeploymentModel var2);

    public abstract void updateDeploymentStatus(J2EEServerInstance var1, DeploymentModel var2);

    public boolean isDeployOrderMatter() {
        return false;
    }

    public boolean isNeedUndeployOnDisconnect() {
        return false;
    }

    public void cleanDeployments(J2EEServerInstance instance, List<DeploymentModel> deploymentModels) {
    }

    public boolean isModuleDeployAllowed() {
        return false;
    }

    public DeploymentMethod @Nullable [] getAvailableMethods() {
        return null;
    }

    @Nullable
    @NonNls
    public String getHelpId() {
        return null;
    }

    public DeploymentModel createNewDeploymentModel(CommonModel commonModel, DeploymentSource source) {
        return null;
    }

    @Nullable
    public SettingsEditor<DeploymentModel> createAdditionalDeploymentSettingsEditor(CommonModel commonModel, DeploymentSource source) {
        return null;
    }

    public boolean isResourcesReloadingSupported(CommonModel model, ArtifactType artifactType) {
        return model.isLocal() && !JavaeeArtifactUtil.getInstance().isArchive(artifactType);
    }

    public Collection<? extends ArtifactType> getSupportedArtifactTypes() {
        return JavaeeArtifactUtil.getInstance().getAllJavaeeArtifactTypes();
    }

    @Nullable
    public ExternalFileDeploymentProvider getExternalFileDeploymentProvider() {
        return JavaeeDeploymentUtil.getInstance().createExternalFileDeploymentProvider(this.getSupportedArtifactTypes());
    }

    public List<CustomDeploymentProvider> getCustomDeploymentProviders() {
        return Collections.emptyList();
    }
}

