/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.apache.batik.bridge;

import java.awt.geom.Rectangle2D;
import java.util.Map;
import java.util.StringTokenizer;
import org.jetbrains.relocated.apache.batik.bridge.AbstractSVGFilterPrimitiveElementBridge;
import org.jetbrains.relocated.apache.batik.bridge.BridgeContext;
import org.jetbrains.relocated.apache.batik.bridge.BridgeException;
import org.jetbrains.relocated.apache.batik.bridge.SVGUtilities;
import org.jetbrains.relocated.apache.batik.ext.awt.image.PadMode;
import org.jetbrains.relocated.apache.batik.ext.awt.image.renderable.Filter;
import org.jetbrains.relocated.apache.batik.ext.awt.image.renderable.GaussianBlurRable8Bit;
import org.jetbrains.relocated.apache.batik.ext.awt.image.renderable.PadRable8Bit;
import org.jetbrains.relocated.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;

public class SVGFeGaussianBlurElementBridge
extends AbstractSVGFilterPrimitiveElementBridge {
    @Override
    public String getLocalName() {
        return "feGaussianBlur";
    }

    @Override
    public Filter createFilter(BridgeContext ctx2, Element filterElement, Element filteredElement, GraphicsNode filteredNode, Filter inputFilter, Rectangle2D filterRegion, Map filterMap) {
        float[] stdDeviationXY = SVGFeGaussianBlurElementBridge.convertStdDeviation(filterElement, ctx2);
        if (stdDeviationXY[0] < 0.0f || stdDeviationXY[1] < 0.0f) {
            throw new BridgeException(ctx2, filterElement, "attribute.malformed", new Object[]{"stdDeviation", String.valueOf(stdDeviationXY[0]) + stdDeviationXY[1]});
        }
        Filter in = SVGFeGaussianBlurElementBridge.getIn(filterElement, filteredElement, filteredNode, inputFilter, filterMap, ctx2);
        if (in == null) {
            return null;
        }
        Rectangle2D defaultRegion = in.getBounds2D();
        Rectangle2D primitiveRegion = SVGUtilities.convertFilterPrimitiveRegion(filterElement, filteredElement, filteredNode, defaultRegion, filterRegion, ctx2);
        PadRable8Bit pad = new PadRable8Bit(in, primitiveRegion, PadMode.ZERO_PAD);
        GaussianBlurRable8Bit blur = new GaussianBlurRable8Bit(pad, stdDeviationXY[0], stdDeviationXY[1]);
        SVGFeGaussianBlurElementBridge.handleColorInterpolationFilters(blur, filterElement);
        PadRable8Bit filter2 = new PadRable8Bit(blur, primitiveRegion, PadMode.ZERO_PAD);
        SVGFeGaussianBlurElementBridge.updateFilterMap(filterElement, filter2, filterMap);
        return filter2;
    }

    protected static float[] convertStdDeviation(Element filterElement, BridgeContext ctx2) {
        String s = filterElement.getAttributeNS(null, "stdDeviation");
        if (s.length() == 0) {
            return new float[]{0.0f, 0.0f};
        }
        float[] stdDevs = new float[2];
        StringTokenizer tokens = new StringTokenizer(s, " ,");
        try {
            stdDevs[0] = SVGUtilities.convertSVGNumber(tokens.nextToken());
            stdDevs[1] = tokens.hasMoreTokens() ? SVGUtilities.convertSVGNumber(tokens.nextToken()) : stdDevs[0];
        }
        catch (NumberFormatException nfEx) {
            throw new BridgeException(ctx2, filterElement, nfEx, "attribute.malformed", new Object[]{"stdDeviation", s, nfEx});
        }
        if (tokens.hasMoreTokens()) {
            throw new BridgeException(ctx2, filterElement, "attribute.malformed", new Object[]{"stdDeviation", s});
        }
        return stdDevs;
    }
}

