/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.session;

import com.intellij.database.run.session.BaseLogView;
import com.intellij.database.run.session.LogView;
import com.intellij.database.run.session.LogViewController;
import com.intellij.database.run.session.SessionToolWindowHelper;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class ToolWindowSessionViewController
implements LogViewController<BaseLogView<?>> {
    protected final Project myProject;
    protected final SessionToolWindowHelper myHelper;

    public ToolWindowSessionViewController(@NotNull Project project, @NotNull SessionToolWindowHelper helper) {
        if (project == null) {
            ToolWindowSessionViewController.$$$reportNull$$$0(0);
        }
        if (helper == null) {
            ToolWindowSessionViewController.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myHelper = helper;
    }

    @NotNull
    public String id() {
        String string = this.myHelper.getToolWindowId();
        if (string == null) {
            ToolWindowSessionViewController.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public Promise<Void> show(@NotNull BaseLogView<?> view, boolean activate, boolean requestFocus, @Nullable LogView.OutputType outputType) {
        ContentManager contentManager;
        if (view == null) {
            ToolWindowSessionViewController.$$$reportNull$$$0(3);
        }
        ToolWindowEx window = this.myHelper.getOrCreateToolWindow(this.myProject);
        view.ensureContentInitialized();
        view.beforeExecution();
        Content content = view.getContent();
        ContentManager contentManager2 = contentManager = content.getManager() == null ? this.retrieveContentManager(view, content, (ToolWindow)window) : content.getManager();
        if (activate) {
            AsyncPromise callback = new AsyncPromise();
            window.activate(() -> {
                if (!content.isValid()) {
                    return;
                }
                contentManager.setSelectedContent(content, requestFocus, false);
                callback.setResult(null);
            }, false, requestFocus);
            AsyncPromise asyncPromise = callback;
            if (asyncPromise == null) {
                ToolWindowSessionViewController.$$$reportNull$$$0(4);
            }
            return asyncPromise;
        }
        contentManager.setSelectedContent(content, requestFocus, false);
        Promise promise = Promises.resolvedPromise();
        if (promise == null) {
            ToolWindowSessionViewController.$$$reportNull$$$0(5);
        }
        return promise;
    }

    @NotNull
    protected ContentManager retrieveContentManager(@NotNull BaseLogView<?> view, @NotNull Content content, @NotNull ToolWindow window) {
        if (view == null) {
            ToolWindowSessionViewController.$$$reportNull$$$0(6);
        }
        if (content == null) {
            ToolWindowSessionViewController.$$$reportNull$$$0(7);
        }
        if (window == null) {
            ToolWindowSessionViewController.$$$reportNull$$$0(8);
        }
        ContentManager contentManager = window.getContentManager();
        window.setAvailable(true);
        EditorColorsUtil.updateNotInHierarchyComponentUIAndColors((Component)content.getComponent());
        contentManager.addContent(content);
        ContentManager contentManager2 = contentManager;
        if (contentManager2 == null) {
            ToolWindowSessionViewController.$$$reportNull$$$0(9);
        }
        return contentManager2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/session/ToolWindowSessionViewController";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/session/ToolWindowSessionViewController";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "id";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "show";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "retrieveContentManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "show";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "retrieveContentManager";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5, 9 -> new IllegalStateException(string);
        };
    }
}

