/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.editor.editor;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleColoredRenderer;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ListIterator;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HoverColoredRenderer {
    private final SimpleColoredText myRegularText = new SimpleColoredTextEx();
    private final SimpleColoredText myHoveredText = new SimpleColoredTextEx();
    private final SimpleColoredComponent myComponent = new SimpleColoredRenderer(){

        @NotNull
        public Dimension getPreferredSize() {
            Dimension res2 = super.getPreferredSize();
            return new Dimension(JBUI.scale((int)100), res2.height);
        }

        @NotNull
        public Dimension getMinimumSize() {
            Dimension dimension = this.getPreferredSize();
            if (dimension == null) {
                1.$$$reportNull$$$0(0);
            }
            return dimension;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/editor/editor/HoverColoredRenderer$1", "getMinimumSize"));
        }
    };
    private boolean myHovered = false;

    public HoverColoredRenderer() {
        this.myComponent.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                HoverColoredRenderer.this.myHovered = true;
                HoverColoredRenderer.this.renderText();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                HoverColoredRenderer.this.myHovered = false;
                HoverColoredRenderer.this.renderText();
            }
        });
    }

    @NotNull
    public JComponent getComponent() {
        SimpleColoredComponent simpleColoredComponent = this.myComponent;
        if (simpleColoredComponent == null) {
            HoverColoredRenderer.$$$reportNull$$$0(0);
        }
        return simpleColoredComponent;
    }

    public void setText(@NotNull SimpleColoredText text) {
        if (text == null) {
            HoverColoredRenderer.$$$reportNull$$$0(1);
        }
        this.myRegularText.clear();
        text.appendToComponent((ColoredTextContainer)this.myRegularText);
        this.myHoveredText.clear();
        text.appendToComponent((ColoredTextContainer)this.myHoveredText);
        HoverColoredRenderer.makeUnderlined(this.myHoveredText);
        this.renderText();
    }

    private static void makeUnderlined(SimpleColoredText text) {
        ListIterator<SimpleTextAttributes> it = text.getAttributes().listIterator();
        while (it.hasNext()) {
            it.set(HoverColoredRenderer.underlined((SimpleTextAttributes)it.next()));
        }
    }

    @NotNull
    private static SimpleTextAttributes underlined(SimpleTextAttributes attrs) {
        return new SimpleTextAttributes(attrs.getBgColor(), attrs.getFgColor(), attrs.getWaveColor(), attrs.getStyle() | 0x10);
    }

    private void renderText() {
        this.myComponent.clear();
        (this.myHovered ? this.myHoveredText : this.myRegularText).appendToComponent((ColoredTextContainer)this.myComponent);
        this.myComponent.repaint();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/editor/editor/HoverColoredRenderer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/editor/editor/HoverColoredRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    public static class SimpleColoredTextEx
    extends SimpleColoredText {
        private Icon myIcon;
        private @NlsContexts.Tooltip String myTooltip;

        public void setIcon(@Nullable Icon icon) {
            this.myIcon = icon;
        }

        public Icon getIcon() {
            return this.myIcon;
        }

        public void setToolTipText(@Nullable String text) {
            this.myTooltip = text;
        }

        @NlsContexts.Tooltip
        public String getTooltip() {
            return this.myTooltip;
        }

        public void appendToComponent(@NotNull ColoredTextContainer component) {
            if (component == null) {
                SimpleColoredTextEx.$$$reportNull$$$0(0);
            }
            super.appendToComponent(component);
            component.setIcon(this.getIcon());
            component.setToolTipText(this.getTooltip());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/database/dbimport/editor/editor/HoverColoredRenderer$SimpleColoredTextEx", "appendToComponent"));
        }
    }
}

