/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.ui;

import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.schemaEditor.DbObjectEditorBuilder;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.model.DbEditorModelController;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.state.DbModelState;
import com.intellij.database.schemaEditor.model.state.DbStructureNodeState;
import com.intellij.database.schemaEditor.ui.DbEditor;
import com.intellij.database.schemaEditor.ui.DbEditorListener;
import com.intellij.database.schemaEditor.ui.DbStructureEditor;
import com.intellij.database.schemaEditor.ui.DbStructureNodeEditor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbEditorController
implements Disposable {
    private final DbEditorModelController myModelController;
    private final Set<DbEditor<?, ?>> myAllEditors;
    private final Map<DbModelRef<?, ?>, DbStructureNodeEditor<?, ?>> myStructureEditors;
    private final EventDispatcher<DbEditorListener> myEventDispatcher;

    public DbEditorController(@NotNull DbEditorModelController modelController) {
        if (modelController == null) {
            DbEditorController.$$$reportNull$$$0(0);
        }
        this.myAllEditors = new LinkedHashSet();
        this.myStructureEditors = new LinkedHashMap();
        this.myEventDispatcher = EventDispatcher.create(DbEditorListener.class);
        this.myModelController = modelController;
    }

    @NotNull
    public UserDataHolder getDataHolder() {
        UserDataHolder userDataHolder = this.myModelController.getDataHolder();
        if (userDataHolder == null) {
            DbEditorController.$$$reportNull$$$0(1);
        }
        return userDataHolder;
    }

    @RequiresEdt
    public boolean registerEditor(@NotNull DbEditor<?, ?> editor2) {
        DbStructureNodeEditor prev2;
        if (editor2 == null) {
            DbEditorController.$$$reportNull$$$0(2);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (!this.myAllEditors.add(editor2)) {
            return false;
        }
        DbStructureNodeEditor se = (DbStructureNodeEditor)ObjectUtils.tryCast(editor2, DbStructureNodeEditor.class);
        if (se != null && (prev2 = this.myStructureEditors.put(se.getModelRef(), se)) != null) {
            throw new AssertionError((Object)"Already have structure editor");
        }
        ((DbEditorListener)this.getEventDispatcher().getMulticaster()).created(editor2);
        return true;
    }

    @RequiresEdt
    public boolean unregisterEditor(@NotNull DbEditor<?, ?> editor2) {
        if (editor2 == null) {
            DbEditorController.$$$reportNull$$$0(3);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (!this.myAllEditors.remove(editor2)) {
            return false;
        }
        DbStructureNodeEditor se = (DbStructureNodeEditor)ObjectUtils.tryCast(editor2, DbStructureNodeEditor.class);
        if (se != null) {
            this.myStructureEditors.remove(se.getModelRef());
        }
        ((DbEditorListener)this.getEventDispatcher().getMulticaster()).removed(editor2);
        return true;
    }

    public boolean isEditorRegistered(@NotNull DbEditor<?, ?> editor2) {
        if (editor2 == null) {
            DbEditorController.$$$reportNull$$$0(4);
        }
        return this.myAllEditors.contains(editor2);
    }

    @NotNull
    public Iterable<DbEditor<?, ?>> getAllEditors() {
        Set<DbEditor<?, ?>> set = this.myAllEditors;
        if (set == null) {
            DbEditorController.$$$reportNull$$$0(5);
        }
        return set;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myModelController.getProject();
        if (project == null) {
            DbEditorController.$$$reportNull$$$0(6);
        }
        return project;
    }

    @NotNull
    public DbObjectEditorBuilder getBuilder() {
        DbObjectEditorBuilder dbObjectEditorBuilder = this.myModelController.getBuilder();
        if (dbObjectEditorBuilder == null) {
            DbEditorController.$$$reportNull$$$0(7);
        }
        return dbObjectEditorBuilder;
    }

    @NotNull
    public DbEditorModelController getModelController() {
        DbEditorModelController dbEditorModelController = this.myModelController;
        if (dbEditorModelController == null) {
            DbEditorController.$$$reportNull$$$0(8);
        }
        return dbEditorModelController;
    }

    @NotNull
    public ModalityState getModalityState() {
        ModalityState modalityState = this.myModelController.getModalityState();
        if (modalityState == null) {
            DbEditorController.$$$reportNull$$$0(9);
        }
        return modalityState;
    }

    public <T> T accessModel(@NotNull @NotNull Function<@NotNull DbEditorModelController, T> processor) {
        if (processor == null) {
            DbEditorController.$$$reportNull$$$0(10);
        }
        return processor.apply(this.myModelController);
    }

    @Nullable
    public ElementIdentity<?> getParent(@Nullable ElementIdentity<?> identity) {
        return identity == null ? null : this.getModelController().getMatcher().getParent(identity);
    }

    @RequiresEdt
    @Nullable
    public <E extends BasicElement, S extends DbStructureNodeState<?, ?>> DbStructureNodeEditor<E, S> getStructureNodeEditor(@NotNull DbModelRef<E, S> modelRef) {
        if (modelRef == null) {
            DbEditorController.$$$reportNull$$$0(11);
        }
        ThreadingAssertions.assertEventDispatchThread();
        DbStructureNodeEditor<?, ?> editor2 = this.myStructureEditors.get(modelRef);
        return editor2;
    }

    @NotNull
    public <E extends BasicElement, S extends DbStructureNodeState<?, ?>> DbStructureNodeEditor<E, S> createStructureNodeEditor(@NotNull DbModelRef<E, S> modelRef) {
        if (modelRef == null) {
            DbEditorController.$$$reportNull$$$0(12);
        }
        DbStructureNodeEditor dbStructureNodeEditor = (DbStructureNodeEditor)Objects.requireNonNull(this.createEditor(modelRef));
        if (dbStructureNodeEditor == null) {
            DbEditorController.$$$reportNull$$$0(13);
        }
        return dbStructureNodeEditor;
    }

    @Nullable
    public <E extends BasicElement, S extends DbModelState> DbEditor<E, S> createEditor(@NotNull DbModelRef<E, S> modelRef) {
        DbStructureNodeState s;
        DbStructureNodeEditor<E, DbStructureNodeState> editor2;
        S s2;
        if (modelRef == null) {
            DbEditorController.$$$reportNull$$$0(14);
        }
        if ((s2 = modelRef.getState()) instanceof DbStructureNodeState && (editor2 = this.getStructureNodeEditor(modelRef.castState(s = (DbStructureNodeState)s2))) != null) {
            return editor2;
        }
        return this.getBuilder().createObjectEditor(this, modelRef);
    }

    public boolean shouldHaveEditor(@NotNull DbModelRef<?, ?> model) {
        if (model == null) {
            DbEditorController.$$$reportNull$$$0(15);
        }
        return this.getBuilder().shouldHaveEditor(model);
    }

    public void dispose() {
    }

    @NotNull
    public EventDispatcher<DbEditorListener> getEventDispatcher() {
        EventDispatcher<DbEditorListener> eventDispatcher = this.myEventDispatcher;
        if (eventDispatcher == null) {
            DbEditorController.$$$reportNull$$$0(16);
        }
        return eventDispatcher;
    }

    @Nullable
    public DbStructureEditor<?> findStructureEditor() {
        return (DbStructureEditor)ContainerUtil.findInstance(this.getAllEditors(), DbStructureEditor.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5, 6, 7, 8, 9, 13, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelController";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/ui/DbEditorController";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelRef";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/ui/DbEditorController";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataHolder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllEditors";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuilder";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelController";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getModalityState";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createStructureNodeEditor";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventDispatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 16: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registerEditor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "unregisterEditor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isEditorRegistered";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "accessModel";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getStructureNodeEditor";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createStructureNodeEditor";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "shouldHaveEditor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5, 6, 7, 8, 9, 13, 16 -> new IllegalStateException(string);
        };
    }
}

