/**
 * workaround for https://github.com/vitest-dev/vitest/issues/2176
 */
function fixRequirePath(relativePath) {
  const fileName = process.env['_JETBRAINS_VITEST_REPORTER_ABSOLUTE_PATH'];
  if (fileName == null) {
    return relativePath; // if --reporter is passed as a relative path, no need to workaround
  }
  const path = require('path');
  return path.join(path.dirname(fileName), relativePath);
}

try {
  let reporterRelativePath = '../vitest-intellij-reporter';
  const vitestMajorVersion = parseInt(process.env['_JETBRAINS_VITEST_MAJOR_VERSION'], 10);
  // Reporter API has been changed since version 3 https://vitest.dev/blog/vitest-3.html#reporter-updates
  // In version 4 some methods were removed https://github.com/vitest-dev/vitest/releases/tag/v4.0.0 (https://github.com/vitest-dev/vitest/pull/8223)
  if (!isNaN(vitestMajorVersion) && vitestMajorVersion >= 3) {
    reporterRelativePath = '../vitest-intellij-reporter-v3-plus.js';
  }
  module.exports = require(fixRequirePath(reporterRelativePath));
}
catch (e) {
  process.stderr.write(e.message + '\n' + e.stack);
}
