package appmallsservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveMessages invokes the appmallsservice.RemoveMessages API synchronously
// api document: https://help.aliyun.com/api/appmallsservice/removemessages.html
func (client *Client) RemoveMessages(request *RemoveMessagesRequest) (response *RemoveMessagesResponse, err error) {
	response = CreateRemoveMessagesResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveMessagesWithChan invokes the appmallsservice.RemoveMessages API asynchronously
// api document: https://help.aliyun.com/api/appmallsservice/removemessages.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RemoveMessagesWithChan(request *RemoveMessagesRequest) (<-chan *RemoveMessagesResponse, <-chan error) {
	responseChan := make(chan *RemoveMessagesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveMessages(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveMessagesWithCallback invokes the appmallsservice.RemoveMessages API asynchronously
// api document: https://help.aliyun.com/api/appmallsservice/removemessages.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RemoveMessagesWithCallback(request *RemoveMessagesRequest, callback func(response *RemoveMessagesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveMessagesResponse
		var err error
		defer close(result)
		response, err = client.RemoveMessages(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveMessagesRequest is the request struct for api RemoveMessages
type RemoveMessagesRequest struct {
	*requests.RpcRequest
	MsgIds     string `position:"Query" name:"MsgIds"`
	ParamsJson string `position:"Query" name:"ParamsJson"`
}

// RemoveMessagesResponse is the response struct for api RemoveMessages
type RemoveMessagesResponse struct {
	*responses.BaseResponse
	ErrorCode     string `json:"ErrorCode" xml:"ErrorCode"`
	Msg           string `json:"Msg" xml:"Msg"`
	SubCode       string `json:"SubCode" xml:"SubCode"`
	SubMsg        string `json:"SubMsg" xml:"SubMsg"`
	LogsId        string `json:"LogsId" xml:"LogsId"`
	RequestId     string `json:"RequestId" xml:"RequestId"`
	ReturnCode    string `json:"ReturnCode" xml:"ReturnCode"`
	ReturnMessage string `json:"ReturnMessage" xml:"ReturnMessage"`
	ReturnValue   string `json:"ReturnValue" xml:"ReturnValue"`
}

// CreateRemoveMessagesRequest creates a request to invoke RemoveMessages API
func CreateRemoveMessagesRequest() (request *RemoveMessagesRequest) {
	request = &RemoveMessagesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("AppMallsService", "2018-02-24", "RemoveMessages", "", "")
	return
}

// CreateRemoveMessagesResponse creates a response to parse from RemoveMessages response
func CreateRemoveMessagesResponse() (response *RemoveMessagesResponse) {
	response = &RemoveMessagesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
