package codeup

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetRepositoryTag invokes the codeup.GetRepositoryTag API synchronously
func (client *Client) GetRepositoryTag(request *GetRepositoryTagRequest) (response *GetRepositoryTagResponse, err error) {
	response = CreateGetRepositoryTagResponse()
	err = client.DoAction(request, response)
	return
}

// GetRepositoryTagWithChan invokes the codeup.GetRepositoryTag API asynchronously
func (client *Client) GetRepositoryTagWithChan(request *GetRepositoryTagRequest) (<-chan *GetRepositoryTagResponse, <-chan error) {
	responseChan := make(chan *GetRepositoryTagResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetRepositoryTag(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetRepositoryTagWithCallback invokes the codeup.GetRepositoryTag API asynchronously
func (client *Client) GetRepositoryTagWithCallback(request *GetRepositoryTagRequest, callback func(response *GetRepositoryTagResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetRepositoryTagResponse
		var err error
		defer close(result)
		response, err = client.GetRepositoryTag(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetRepositoryTagRequest is the request struct for api GetRepositoryTag
type GetRepositoryTagRequest struct {
	*requests.RoaRequest
	OrganizationId string           `position:"Query" name:"OrganizationId"`
	TagName        string           `position:"Path" name:"TagName"`
	AccessToken    string           `position:"Query" name:"AccessToken"`
	ProjectId      requests.Integer `position:"Path" name:"ProjectId"`
}

// GetRepositoryTagResponse is the response struct for api GetRepositoryTag
type GetRepositoryTagResponse struct {
	*responses.BaseResponse
	RequestId    string                   `json:"RequestId" xml:"RequestId"`
	ErrorCode    string                   `json:"ErrorCode" xml:"ErrorCode"`
	Success      bool                     `json:"Success" xml:"Success"`
	ErrorMessage string                   `json:"ErrorMessage" xml:"ErrorMessage"`
	Result       ResultInGetRepositoryTag `json:"Result" xml:"Result"`
}

// CreateGetRepositoryTagRequest creates a request to invoke GetRepositoryTag API
func CreateGetRepositoryTagRequest() (request *GetRepositoryTagRequest) {
	request = &GetRepositoryTagRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("codeup", "2020-04-14", "GetRepositoryTag", "/api/v3/projects/[ProjectId]/repository/tags/[TagName]", "", "")
	request.Method = requests.GET
	return
}

// CreateGetRepositoryTagResponse creates a response to parse from GetRepositoryTag response
func CreateGetRepositoryTagResponse() (response *GetRepositoryTagResponse) {
	response = &GetRepositoryTagResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
