package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CapacityPlan invokes the elasticsearch.CapacityPlan API synchronously
func (client *Client) CapacityPlan(request *CapacityPlanRequest) (response *CapacityPlanResponse, err error) {
	response = CreateCapacityPlanResponse()
	err = client.DoAction(request, response)
	return
}

// CapacityPlanWithChan invokes the elasticsearch.CapacityPlan API asynchronously
func (client *Client) CapacityPlanWithChan(request *CapacityPlanRequest) (<-chan *CapacityPlanResponse, <-chan error) {
	responseChan := make(chan *CapacityPlanResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CapacityPlan(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CapacityPlanWithCallback invokes the elasticsearch.CapacityPlan API asynchronously
func (client *Client) CapacityPlanWithCallback(request *CapacityPlanRequest, callback func(response *CapacityPlanResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CapacityPlanResponse
		var err error
		defer close(result)
		response, err = client.CapacityPlan(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CapacityPlanRequest is the request struct for api CapacityPlan
type CapacityPlanRequest struct {
	*requests.RoaRequest
}

// CapacityPlanResponse is the response struct for api CapacityPlan
type CapacityPlanResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateCapacityPlanRequest creates a request to invoke CapacityPlan API
func CreateCapacityPlanRequest() (request *CapacityPlanRequest) {
	request = &CapacityPlanRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "CapacityPlan", "/openapi/assist/actions/capacity-plan", "elasticsearch", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCapacityPlanResponse creates a response to parse from CapacityPlan response
func CreateCapacityPlanResponse() (response *CapacityPlanResponse) {
	response = &CapacityPlanResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
