package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDiagnoseReport invokes the elasticsearch.DescribeDiagnoseReport API synchronously
func (client *Client) DescribeDiagnoseReport(request *DescribeDiagnoseReportRequest) (response *DescribeDiagnoseReportResponse, err error) {
	response = CreateDescribeDiagnoseReportResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDiagnoseReportWithChan invokes the elasticsearch.DescribeDiagnoseReport API asynchronously
func (client *Client) DescribeDiagnoseReportWithChan(request *DescribeDiagnoseReportRequest) (<-chan *DescribeDiagnoseReportResponse, <-chan error) {
	responseChan := make(chan *DescribeDiagnoseReportResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDiagnoseReport(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDiagnoseReportWithCallback invokes the elasticsearch.DescribeDiagnoseReport API asynchronously
func (client *Client) DescribeDiagnoseReportWithCallback(request *DescribeDiagnoseReportRequest, callback func(response *DescribeDiagnoseReportResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDiagnoseReportResponse
		var err error
		defer close(result)
		response, err = client.DescribeDiagnoseReport(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDiagnoseReportRequest is the request struct for api DescribeDiagnoseReport
type DescribeDiagnoseReportRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"InstanceId"`
	ReportId   string `position:"Path" name:"ReportId"`
	Lang       string `position:"Query" name:"lang"`
}

// DescribeDiagnoseReportResponse is the response struct for api DescribeDiagnoseReport
type DescribeDiagnoseReportResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateDescribeDiagnoseReportRequest creates a request to invoke DescribeDiagnoseReport API
func CreateDescribeDiagnoseReportRequest() (request *DescribeDiagnoseReportRequest) {
	request = &DescribeDiagnoseReportRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "DescribeDiagnoseReport", "/openapi/diagnosis/instances/[InstanceId]/reports/[ReportId]", "elasticsearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeDiagnoseReportResponse creates a response to parse from DescribeDiagnoseReport response
func CreateDescribeDiagnoseReportResponse() (response *DescribeDiagnoseReportResponse) {
	response = &DescribeDiagnoseReportResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
