package hitsdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateInstanceIpWhiteList invokes the hitsdb.UpdateInstanceIpWhiteList API synchronously
func (client *Client) UpdateInstanceIpWhiteList(request *UpdateInstanceIpWhiteListRequest) (response *UpdateInstanceIpWhiteListResponse, err error) {
	response = CreateUpdateInstanceIpWhiteListResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateInstanceIpWhiteListWithChan invokes the hitsdb.UpdateInstanceIpWhiteList API asynchronously
func (client *Client) UpdateInstanceIpWhiteListWithChan(request *UpdateInstanceIpWhiteListRequest) (<-chan *UpdateInstanceIpWhiteListResponse, <-chan error) {
	responseChan := make(chan *UpdateInstanceIpWhiteListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateInstanceIpWhiteList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateInstanceIpWhiteListWithCallback invokes the hitsdb.UpdateInstanceIpWhiteList API asynchronously
func (client *Client) UpdateInstanceIpWhiteListWithCallback(request *UpdateInstanceIpWhiteListRequest, callback func(response *UpdateInstanceIpWhiteListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateInstanceIpWhiteListResponse
		var err error
		defer close(result)
		response, err = client.UpdateInstanceIpWhiteList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateInstanceIpWhiteListRequest is the request struct for api UpdateInstanceIpWhiteList
type UpdateInstanceIpWhiteListRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	GroupName            string           `position:"Query" name:"GroupName"`
	SecurityIpList       string           `position:"Query" name:"SecurityIpList"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
}

// UpdateInstanceIpWhiteListResponse is the response struct for api UpdateInstanceIpWhiteList
type UpdateInstanceIpWhiteListResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateInstanceIpWhiteListRequest creates a request to invoke UpdateInstanceIpWhiteList API
func CreateUpdateInstanceIpWhiteListRequest() (request *UpdateInstanceIpWhiteListRequest) {
	request = &UpdateInstanceIpWhiteListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("hitsdb", "2020-06-15", "UpdateInstanceIpWhiteList", "hitsdb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateInstanceIpWhiteListResponse creates a response to parse from UpdateInstanceIpWhiteList response
func CreateUpdateInstanceIpWhiteListResponse() (response *UpdateInstanceIpWhiteListResponse) {
	response = &UpdateInstanceIpWhiteListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
