package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchUpdateDeviceNickname invokes the iot.BatchUpdateDeviceNickname API synchronously
func (client *Client) BatchUpdateDeviceNickname(request *BatchUpdateDeviceNicknameRequest) (response *BatchUpdateDeviceNicknameResponse, err error) {
	response = CreateBatchUpdateDeviceNicknameResponse()
	err = client.DoAction(request, response)
	return
}

// BatchUpdateDeviceNicknameWithChan invokes the iot.BatchUpdateDeviceNickname API asynchronously
func (client *Client) BatchUpdateDeviceNicknameWithChan(request *BatchUpdateDeviceNicknameRequest) (<-chan *BatchUpdateDeviceNicknameResponse, <-chan error) {
	responseChan := make(chan *BatchUpdateDeviceNicknameResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchUpdateDeviceNickname(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchUpdateDeviceNicknameWithCallback invokes the iot.BatchUpdateDeviceNickname API asynchronously
func (client *Client) BatchUpdateDeviceNicknameWithCallback(request *BatchUpdateDeviceNicknameRequest, callback func(response *BatchUpdateDeviceNicknameResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchUpdateDeviceNicknameResponse
		var err error
		defer close(result)
		response, err = client.BatchUpdateDeviceNickname(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchUpdateDeviceNicknameRequest is the request struct for api BatchUpdateDeviceNickname
type BatchUpdateDeviceNicknameRequest struct {
	*requests.RpcRequest
	RealTenantId       string                                         `position:"Query" name:"RealTenantId"`
	RealTripartiteKey  string                                         `position:"Query" name:"RealTripartiteKey"`
	IotInstanceId      string                                         `position:"Query" name:"IotInstanceId"`
	DeviceNicknameInfo *[]BatchUpdateDeviceNicknameDeviceNicknameInfo `position:"Query" name:"DeviceNicknameInfo"  type:"Repeated"`
	ApiProduct         string                                         `position:"Body" name:"ApiProduct"`
	ApiRevision        string                                         `position:"Body" name:"ApiRevision"`
}

// BatchUpdateDeviceNicknameDeviceNicknameInfo is a repeated param struct in BatchUpdateDeviceNicknameRequest
type BatchUpdateDeviceNicknameDeviceNicknameInfo struct {
	IotId      string `name:"IotId"`
	Nickname   string `name:"Nickname"`
	DeviceName string `name:"DeviceName"`
	ProductKey string `name:"ProductKey"`
}

// BatchUpdateDeviceNicknameResponse is the response struct for api BatchUpdateDeviceNickname
type BatchUpdateDeviceNicknameResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateBatchUpdateDeviceNicknameRequest creates a request to invoke BatchUpdateDeviceNickname API
func CreateBatchUpdateDeviceNicknameRequest() (request *BatchUpdateDeviceNicknameRequest) {
	request = &BatchUpdateDeviceNicknameRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "BatchUpdateDeviceNickname", "", "")
	request.Method = requests.POST
	return
}

// CreateBatchUpdateDeviceNicknameResponse creates a response to parse from BatchUpdateDeviceNickname response
func CreateBatchUpdateDeviceNicknameResponse() (response *BatchUpdateDeviceNicknameResponse) {
	response = &BatchUpdateDeviceNicknameResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
