package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateGatewayRouteTimeout invokes the mse.UpdateGatewayRouteTimeout API synchronously
func (client *Client) UpdateGatewayRouteTimeout(request *UpdateGatewayRouteTimeoutRequest) (response *UpdateGatewayRouteTimeoutResponse, err error) {
	response = CreateUpdateGatewayRouteTimeoutResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateGatewayRouteTimeoutWithChan invokes the mse.UpdateGatewayRouteTimeout API asynchronously
func (client *Client) UpdateGatewayRouteTimeoutWithChan(request *UpdateGatewayRouteTimeoutRequest) (<-chan *UpdateGatewayRouteTimeoutResponse, <-chan error) {
	responseChan := make(chan *UpdateGatewayRouteTimeoutResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateGatewayRouteTimeout(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateGatewayRouteTimeoutWithCallback invokes the mse.UpdateGatewayRouteTimeout API asynchronously
func (client *Client) UpdateGatewayRouteTimeoutWithCallback(request *UpdateGatewayRouteTimeoutRequest, callback func(response *UpdateGatewayRouteTimeoutResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateGatewayRouteTimeoutResponse
		var err error
		defer close(result)
		response, err = client.UpdateGatewayRouteTimeout(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateGatewayRouteTimeoutRequest is the request struct for api UpdateGatewayRouteTimeout
type UpdateGatewayRouteTimeoutRequest struct {
	*requests.RpcRequest
	TimeoutJSON     UpdateGatewayRouteTimeoutTimeoutJSON `position:"Query" name:"TimeoutJSON"  type:"Struct"`
	GatewayUniqueId string                               `position:"Query" name:"GatewayUniqueId"`
	AcceptLanguage  string                               `position:"Query" name:"AcceptLanguage"`
	Id              requests.Integer                     `position:"Query" name:"Id"`
	GatewayId       requests.Integer                     `position:"Query" name:"GatewayId"`
}

// UpdateGatewayRouteTimeoutTimeoutJSON is a repeated param struct in UpdateGatewayRouteTimeoutRequest
type UpdateGatewayRouteTimeoutTimeoutJSON struct {
	TimeUnit string `name:"TimeUnit"`
	UnitNum  string `name:"UnitNum"`
	Status   string `name:"Status"`
}

// UpdateGatewayRouteTimeoutResponse is the response struct for api UpdateGatewayRouteTimeout
type UpdateGatewayRouteTimeoutResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	Code           int    `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
	Data           int64  `json:"Data" xml:"Data"`
}

// CreateUpdateGatewayRouteTimeoutRequest creates a request to invoke UpdateGatewayRouteTimeout API
func CreateUpdateGatewayRouteTimeoutRequest() (request *UpdateGatewayRouteTimeoutRequest) {
	request = &UpdateGatewayRouteTimeoutRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "UpdateGatewayRouteTimeout", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateGatewayRouteTimeoutResponse creates a response to parse from UpdateGatewayRouteTimeout response
func CreateUpdateGatewayRouteTimeoutResponse() (response *UpdateGatewayRouteTimeoutResponse) {
	response = &UpdateGatewayRouteTimeoutResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
