package servicemesh

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteServiceMesh invokes the servicemesh.DeleteServiceMesh API synchronously
func (client *Client) DeleteServiceMesh(request *DeleteServiceMeshRequest) (response *DeleteServiceMeshResponse, err error) {
	response = CreateDeleteServiceMeshResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteServiceMeshWithChan invokes the servicemesh.DeleteServiceMesh API asynchronously
func (client *Client) DeleteServiceMeshWithChan(request *DeleteServiceMeshRequest) (<-chan *DeleteServiceMeshResponse, <-chan error) {
	responseChan := make(chan *DeleteServiceMeshResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteServiceMesh(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteServiceMeshWithCallback invokes the servicemesh.DeleteServiceMesh API asynchronously
func (client *Client) DeleteServiceMeshWithCallback(request *DeleteServiceMeshRequest, callback func(response *DeleteServiceMeshResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteServiceMeshResponse
		var err error
		defer close(result)
		response, err = client.DeleteServiceMesh(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteServiceMeshRequest is the request struct for api DeleteServiceMesh
type DeleteServiceMeshRequest struct {
	*requests.RpcRequest
	ServiceMeshId string           `position:"Body" name:"ServiceMeshId"`
	Force         requests.Boolean `position:"Body" name:"Force"`
}

// DeleteServiceMeshResponse is the response struct for api DeleteServiceMesh
type DeleteServiceMeshResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteServiceMeshRequest creates a request to invoke DeleteServiceMesh API
func CreateDeleteServiceMeshRequest() (request *DeleteServiceMeshRequest) {
	request = &DeleteServiceMeshRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("servicemesh", "2020-01-11", "DeleteServiceMesh", "servicemesh", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteServiceMeshResponse creates a response to parse from DeleteServiceMesh response
func CreateDeleteServiceMeshResponse() (response *DeleteServiceMeshResponse) {
	response = &DeleteServiceMeshResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
