/*
 * Decompiled with CFR 0.152.
 */
package charm.debug;

import charm.debug.preference.Execution;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ParamsDialog
extends JDialog
implements ActionListener,
ChangeListener {
    Execution exec = null;
    private JTextField clParams;
    private JTextField numPes;
    private JTextField portno;
    private JTextField sshport;
    private JTextField hostname;
    private JTextField username;
    private JTextField filename;
    private JTextField dir;
    private JTextField inputFile;
    private JTextField virtualPes;
    private JTextField recordPes;
    private JTextField replayPe;
    private JCheckBox suspendOnStart;
    private JCheckBox sshTunnel;
    private JCheckBox waitFile;
    private JCheckBox virtualDebug;
    private JCheckBox recplayActive;
    private JCheckBox recplayDetail;
    private JCheckBox recplayChecksum;
    private JButton chooser;
    private JButton dirchooser;
    private JLabel virtualPeslabel;
    private JRadioButton record;
    private JRadioButton replay;
    private JRadioButton recordDetail;
    private JRadioButton replayDetail;
    private JRadioButton checksumXOR;
    private JRadioButton checksumCRC;
    private JPanel recplayEnabled;
    private JPanel fullEnabled;
    private JPanel checksumEnabled;

    public ParamsDialog(Frame parent, boolean modal, Execution obj) {
        super(parent, modal);
        this.exec = obj;
        this.initComponents();
        this.pack();
        this.setResizable(false);
    }

    private void initComponents() {
        this.setTitle("Program Parameters");
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel contents = new JPanel();
        int nextLine = 0;
        GridBagLayout grid = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        contents.setLayout(grid);
        c.gridx = 0;
        c.gridy = nextLine;
        c.gridwidth = 1;
        c.anchor = 17;
        c.insets = new Insets(12, 12, 0, 0);
        JLabel filenamelabel = new JLabel("Executable:");
        filenamelabel.setLabelFor(this.filename);
        grid.setConstraints(filenamelabel, c);
        contents.add(filenamelabel);
        this.filename = new JTextField(35);
        this.filename.setActionCommand("cmd.ok");
        this.filename.addActionListener(this);
        c.gridx = 1;
        c.gridy = nextLine;
        c.gridwidth = 2;
        c.fill = 2;
        c.weightx = 1.0;
        c.insets = new Insets(11, 7, 0, 0);
        grid.setConstraints(this.filename, c);
        this.chooser = new JButton("Change");
        this.chooser.setActionCommand("browse");
        this.chooser.addActionListener(this);
        c.gridx = 3;
        c.gridy = nextLine++;
        c.gridwidth = 1;
        c.fill = 13;
        c.insets = new Insets(12, 5, 0, 10);
        grid.setConstraints(this.chooser, c);
        c.gridx = 0;
        c.gridy = nextLine;
        c.gridwidth = 1;
        c.anchor = 17;
        c.insets = new Insets(12, 12, 0, 0);
        JLabel dirlabel = new JLabel("Working dir:");
        dirlabel.setLabelFor(this.dir);
        grid.setConstraints(dirlabel, c);
        contents.add(dirlabel);
        this.dir = new JTextField(35);
        this.dir.setActionCommand("cmd.ok");
        this.dir.addActionListener(this);
        c.gridx = 1;
        c.gridy = nextLine;
        c.gridwidth = 2;
        c.fill = 2;
        c.weightx = 1.0;
        c.insets = new Insets(11, 7, 0, 0);
        grid.setConstraints(this.dir, c);
        this.dirchooser = new JButton("Change");
        this.dirchooser.setActionCommand("browsedir");
        this.dirchooser.addActionListener(this);
        c.gridx = 3;
        c.gridy = nextLine++;
        c.gridwidth = 1;
        c.fill = 13;
        c.insets = new Insets(12, 5, 0, 10);
        grid.setConstraints(this.dirchooser, c);
        c.gridx = 0;
        c.gridy = nextLine;
        c.gridwidth = 1;
        c.anchor = 17;
        c.insets = new Insets(12, 12, 0, 0);
        JLabel paramlabel = new JLabel();
        paramlabel.setText("Command Line Parameters:");
        paramlabel.setLabelFor(this.clParams);
        grid.setConstraints(paramlabel, c);
        contents.add(paramlabel);
        this.clParams = new JTextField(35);
        this.clParams.setActionCommand("cmd.ok");
        this.clParams.addActionListener(this);
        c.gridx = 1;
        c.gridy = nextLine++;
        c.gridwidth = 3;
        c.fill = 2;
        c.weightx = 1.0;
        c.insets = new Insets(11, 7, 0, 0);
        grid.setConstraints(this.clParams, c);
        c.gridx = 0;
        c.gridy = nextLine;
        c.gridwidth = 1;
        c.anchor = 17;
        c.insets = new Insets(12, 12, 0, 0);
        JLabel peslabel = new JLabel();
        peslabel.setText("Number of Processors:");
        peslabel.setLabelFor(this.numPes);
        grid.setConstraints(peslabel, c);
        contents.add(peslabel);
        this.numPes = new JTextField(5);
        this.numPes.setActionCommand("cmd.ok");
        this.numPes.addActionListener(this);
        c.gridx = 1;
        c.gridy = nextLine++;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(12, 8, 0, 0);
        grid.setConstraints(this.numPes, c);
        c.gridx = 1;
        c.gridy = nextLine++;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, 4, 0, 0);
        this.suspendOnStart = new JCheckBox("Suspend execution at startup");
        grid.setConstraints(this.suspendOnStart, c);
        c.gridx = 0;
        c.gridy = nextLine;
        c.anchor = 17;
        c.insets = new Insets(12, 8, 0, 0);
        this.virtualDebug = new JCheckBox("Virtualized debugging:");
        this.virtualDebug.addChangeListener(this);
        grid.setConstraints(this.virtualDebug, c);
        contents.add(this.virtualDebug);
        c.gridx = 1;
        c.gridy = nextLine;
        c.gridwidth = 1;
        c.anchor = 17;
        c.insets = new Insets(12, 8, 0, 0);
        this.virtualPeslabel = new JLabel();
        this.virtualPeslabel.setText("Number of Virtal Processors:");
        this.virtualPeslabel.setForeground(Color.GRAY);
        this.virtualPeslabel.setLabelFor(this.virtualPes);
        grid.setConstraints(this.virtualPeslabel, c);
        contents.add(this.virtualPeslabel);
        c.gridx = 2;
        c.gridy = nextLine++;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(12, 8, 0, 0);
        this.virtualPes = new JTextField(5);
        this.virtualPes.setEnabled(false);
        this.virtualPes.setActionCommand("cmd.ok");
        this.virtualPes.addActionListener(this);
        grid.setConstraints(this.virtualPes, c);
        contents.add(this.virtualPes);
        c.gridx = 0;
        c.gridy = nextLine;
        c.anchor = 17;
        c.insets = new Insets(12, 12, 0, 0);
        JLabel portNumberLabel = new JLabel();
        portNumberLabel.setText("Port Number:");
        portNumberLabel.setLabelFor(this.portno);
        grid.setConstraints(portNumberLabel, c);
        contents.add(portNumberLabel);
        c.gridx = 1;
        c.gridy = nextLine++;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(12, 8, 0, 0);
        this.portno = new JTextField(5);
        this.portno.setActionCommand("cmd.ok");
        this.portno.addActionListener(this);
        grid.setConstraints(this.portno, c);
        c.gridx = 0;
        c.gridy = nextLine;
        c.anchor = 17;
        c.insets = new Insets(12, 12, 0, 0);
        JLabel sshportNameLabel = new JLabel();
        sshportNameLabel.setText("SSH port number:");
        sshportNameLabel.setLabelFor(this.sshport);
        grid.setConstraints(sshportNameLabel, c);
        contents.add(sshportNameLabel);
        c.gridx = 1;
        c.gridy = nextLine++;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(12, 8, 0, 0);
        this.sshport = new JTextField(5);
        this.sshport.setActionCommand("cmd.ok");
        this.sshport.addActionListener(this);
        grid.setConstraints(this.sshport, c);
        c.gridx = 0;
        c.gridy = nextLine;
        c.anchor = 17;
        c.insets = new Insets(12, 12, 0, 0);
        JLabel hostNameLabel = new JLabel();
        hostNameLabel.setText("Host name:");
        hostNameLabel.setLabelFor(this.hostname);
        grid.setConstraints(hostNameLabel, c);
        contents.add(hostNameLabel);
        c.gridx = 1;
        c.gridy = nextLine++;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(12, 8, 0, 0);
        this.hostname = new JTextField(20);
        this.hostname.setActionCommand("cmd.ok");
        this.hostname.addActionListener(this);
        grid.setConstraints(this.hostname, c);
        c.gridx = 0;
        c.gridy = nextLine;
        c.anchor = 17;
        c.insets = new Insets(6, 12, 0, 0);
        JLabel userNameLabel = new JLabel();
        userNameLabel.setText("Username:");
        userNameLabel.setLabelFor(this.username);
        grid.setConstraints(userNameLabel, c);
        contents.add(userNameLabel);
        c.gridx = 1;
        c.gridy = nextLine++;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(6, 8, 0, 0);
        this.username = new JTextField(15);
        this.username.setActionCommand("cmd.ok");
        this.username.addActionListener(this);
        grid.setConstraints(this.username, c);
        c.gridx = 0;
        c.gridy = nextLine;
        c.anchor = 17;
        c.insets = new Insets(6, 12, 0, 0);
        JLabel inputFileLabel = new JLabel();
        inputFileLabel.setText("Input file:");
        inputFileLabel.setLabelFor(this.inputFile);
        grid.setConstraints(inputFileLabel, c);
        contents.add(inputFileLabel);
        c.gridx = 1;
        c.gridy = nextLine++;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(6, 8, 0, 0);
        this.inputFile = new JTextField(15);
        this.inputFile.setActionCommand("cmd.ok");
        this.inputFile.addActionListener(this);
        grid.setConstraints(this.inputFile, c);
        c.gridx = 1;
        c.gridy = nextLine++;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, 4, 0, 0);
        this.waitFile = new JCheckBox("Wait for file to be created");
        grid.setConstraints(this.waitFile, c);
        c.gridx = 1;
        c.gridy = nextLine;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, 4, 0, 0);
        this.sshTunnel = new JCheckBox("Use ssh tunneling");
        grid.setConstraints(this.sshTunnel, c);
        contents.add(this.filename);
        contents.add(this.chooser);
        contents.add(this.dir);
        contents.add(this.dirchooser);
        contents.add(this.clParams);
        contents.add(this.numPes);
        contents.add(this.portno);
        contents.add(this.sshport);
        contents.add(this.hostname);
        contents.add(this.username);
        contents.add(this.inputFile);
        contents.add(this.waitFile);
        contents.add(this.sshTunnel);
        contents.add(this.suspendOnStart);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        JButton okButton = new JButton();
        okButton.setText("OK");
        okButton.setActionCommand("cmd.ok");
        okButton.addActionListener(this);
        buttonPanel.add(okButton);
        buttonPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        JButton cancelButton = new JButton();
        cancelButton.setText("CANCEL");
        cancelButton.setActionCommand("cmd.cancel");
        cancelButton.addActionListener(this);
        buttonPanel.add(cancelButton);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("Basic", contents);
        JPanel recplay = new JPanel();
        GridBagLayout recplayGrid = new GridBagLayout();
        GridBagConstraints recplayConstraint = new GridBagConstraints();
        recplayConstraint.gridwidth = 1;
        recplayConstraint.fill = 0;
        recplayConstraint.anchor = 17;
        recplay.setLayout(recplayGrid);
        this.recplayActive = new JCheckBox("Enable Record/Replay");
        this.recplayActive.addChangeListener(this);
        recplayConstraint.gridx = 0;
        recplayConstraint.gridy = 0;
        recplayGrid.setConstraints(this.recplayActive, recplayConstraint);
        recplay.add(this.recplayActive);
        this.recplayEnabled = new JPanel();
        this.recplayEnabled.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        this.recplayEnabled.setLayout(new BoxLayout(this.recplayEnabled, 1));
        recplayConstraint.gridx = 0;
        recplayConstraint.gridy = 1;
        recplayGrid.setConstraints(this.recplayEnabled, recplayConstraint);
        recplay.add(this.recplayEnabled);
        ButtonGroup msgOrder = new ButtonGroup();
        this.record = new JRadioButton("Record the ordering of the messages", true);
        msgOrder.add(this.record);
        this.recplayEnabled.add(this.record);
        this.replay = new JRadioButton("Replay the message ordering", false);
        this.replay.addChangeListener(this);
        msgOrder.add(this.replay);
        this.recplayEnabled.add(this.replay);
        this.recplayDetail = new JCheckBox("Enable detailed Record/Replay");
        this.recplayEnabled.add(this.recplayDetail);
        this.recplayDetail.addChangeListener(this);
        this.fullEnabled = new JPanel();
        this.fullEnabled.setBorder(BorderFactory.createEmptyBorder(0, 40, 0, 0));
        this.fullEnabled.setLayout(new BoxLayout(this.fullEnabled, 1));
        recplayConstraint.gridx = 0;
        recplayConstraint.gridy = 2;
        recplayGrid.setConstraints(this.fullEnabled, recplayConstraint);
        recplay.add(this.fullEnabled);
        JPanel fullPanel = new JPanel();
        GridBagLayout fullPanelGrid = new GridBagLayout();
        GridBagConstraints c1 = new GridBagConstraints();
        c1.gridwidth = 1;
        c1.fill = 0;
        c1.anchor = 17;
        fullPanel.setLayout(fullPanelGrid);
        ButtonGroup fullRecord = new ButtonGroup();
        this.recordDetail = new JRadioButton("Record selected processors", true);
        this.recordDetail.addChangeListener(this);
        fullRecord.add(this.recordDetail);
        c1.gridx = 0;
        c1.gridy = 0;
        fullPanelGrid.setConstraints(this.recordDetail, c1);
        fullPanel.add(this.recordDetail);
        this.recordPes = new JTextField(15);
        c1.gridx = 1;
        c1.gridy = 0;
        fullPanelGrid.setConstraints(this.recordPes, c1);
        fullPanel.add(this.recordPes);
        this.replayDetail = new JRadioButton("Replay selected processor", false);
        this.replayDetail.addChangeListener(this);
        fullRecord.add(this.replayDetail);
        c1.gridx = 0;
        c1.gridy = 1;
        fullPanelGrid.setConstraints(this.replayDetail, c1);
        fullPanel.add(this.replayDetail);
        this.replayPe = new JTextField(5);
        c1.gridx = 1;
        c1.gridy = 1;
        fullPanelGrid.setConstraints(this.replayPe, c1);
        fullPanel.add(this.replayPe);
        c1.gridx = 2;
        c1.gridy = 2;
        c1.weightx = 1.0;
        c1.weighty = 1.0;
        JPanel empty = new JPanel();
        fullPanelGrid.setConstraints(empty, c1);
        fullPanel.add(empty);
        this.fullEnabled.add(fullPanel);
        this.recplayChecksum = new JCheckBox("Enable checksum error detection");
        recplayConstraint.gridx = 1;
        recplayConstraint.gridy = 0;
        recplayGrid.setConstraints(this.recplayChecksum, recplayConstraint);
        recplay.add(this.recplayChecksum);
        this.recplayChecksum.addChangeListener(this);
        this.checksumEnabled = new JPanel();
        this.checksumEnabled.setBorder(BorderFactory.createEmptyBorder(0, 40, 0, 0));
        this.checksumEnabled.setLayout(new BoxLayout(this.checksumEnabled, 1));
        recplayConstraint.gridx = 1;
        recplayConstraint.gridy = 1;
        recplayGrid.setConstraints(this.checksumEnabled, recplayConstraint);
        recplay.add(this.checksumEnabled);
        JPanel checksumPanel = new JPanel();
        GridBagLayout checksumPanelGrid = new GridBagLayout();
        GridBagConstraints c2 = new GridBagConstraints();
        c2.gridwidth = 1;
        c2.fill = 0;
        c2.anchor = 17;
        checksumPanel.setLayout(checksumPanelGrid);
        ButtonGroup checksumGroup = new ButtonGroup();
        this.checksumXOR = new JRadioButton("XOR-based checksum", true);
        this.checksumXOR.addChangeListener(this);
        checksumGroup.add(this.checksumXOR);
        c2.gridx = 0;
        c2.gridy = 0;
        checksumPanelGrid.setConstraints(this.checksumXOR, c2);
        checksumPanel.add(this.checksumXOR);
        this.checksumCRC = new JRadioButton("CRC-32 checksum", false);
        this.checksumCRC.addChangeListener(this);
        checksumGroup.add(this.checksumCRC);
        c2.gridx = 0;
        c2.gridy = 1;
        checksumPanelGrid.setConstraints(this.checksumCRC, c2);
        checksumPanel.add(this.checksumCRC);
        c2.gridx = 1;
        c2.gridy = 2;
        c2.weightx = 1.0;
        c2.weighty = 1.0;
        JPanel empty2 = new JPanel();
        checksumPanelGrid.setConstraints(empty2, c2);
        checksumPanel.add(empty2);
        this.checksumEnabled.add(checksumPanel);
        JPanel empty1 = new JPanel();
        recplayConstraint.gridx = 0;
        recplayConstraint.gridy = 5;
        recplayConstraint.weightx = 1.0;
        recplayConstraint.weighty = 1.0;
        recplayGrid.setConstraints(empty1, recplayConstraint);
        recplay.add(empty1);
        tabbedPane.addTab("Record/Replay", recplay);
        this.getContentPane().add(tabbedPane);
        this.getContentPane().add(buttonPanel);
        this.filename.setText(this.exec.executable);
        this.clParams.setText(this.exec.parameters);
        if (!this.exec.doNotSuspend) {
            this.suspendOnStart.setSelected(true);
        }
        this.numPes.setText("" + this.exec.npes);
        this.portno.setText("" + this.exec.port);
        this.sshport.setText("" + this.exec.sshport);
        this.hostname.setText(this.exec.hostname);
        this.username.setText(this.exec.username);
        this.inputFile.setText(this.exec.inputFile);
        this.waitFile.setSelected(this.exec.waitFile);
        this.sshTunnel.setSelected(this.exec.sshTunnel);
        this.dir.setText(this.exec.workingDir);
        this.virtualDebug.setSelected(this.exec.virtualDebug);
        if (this.exec.virtualDebug) {
            this.virtualPeslabel.setForeground(Color.BLACK);
            this.virtualPes.setEnabled(true);
        }
        this.virtualPes.setText("" + this.exec.virtualNpes);
        if (this.exec.recplayActive) {
            this.recplayActive.setSelected(true);
        }
        if (this.exec.recplayDetailActive) {
            this.recplayDetail.setSelected(true);
        }
        if (this.exec.replay) {
            this.replay.setSelected(true);
        }
        if (this.exec.replayDetail) {
            this.replayDetail.setSelected(true);
        }
        if (this.recordDetail.isSelected()) {
            this.recordPes.setText(this.exec.selectedPes);
        } else if (this.replayDetail.isSelected()) {
            this.replayPe.setText(this.exec.selectedPes);
        }
        if (this.exec.recplayChecksum != 0) {
            this.recplayChecksum.setSelected(true);
            if (this.exec.recplayChecksum == 1) {
                this.checksumXOR.setSelected(true);
            } else if (this.exec.recplayChecksum == 2) {
                this.checksumCRC.setSelected(true);
            }
        }
        this.enableRecplay();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean closeWindow = false;
        if (e.getActionCommand().equals("browse")) {
            JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                this.filename.setText(chooser.getSelectedFile().getAbsolutePath());
            }
        } else if (e.getActionCommand().equals("browsedir")) {
            JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));
            chooser.setFileSelectionMode(1);
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                this.dir.setText(chooser.getSelectedFile().getAbsolutePath());
            }
        } else if (e.getActionCommand().equals("cmd.cancel")) {
            closeWindow = true;
        } else if (e.getActionCommand().equals("cmd.ok")) {
            int numberPes;
            int vPes = 0;
            int sshportNumber = 0;
            try {
                numberPes = Integer.parseInt(this.numPes.getText());
                if (!this.portno.getText().equals("")) {
                    int n = Integer.parseInt(this.portno.getText());
                }
                if (!this.sshport.getText().equals("")) {
                    sshportNumber = Integer.parseInt(this.sshport.getText());
                }
                if (this.virtualDebug.isSelected()) {
                    vPes = Integer.parseInt(this.virtualPes.getText());
                }
            }
            catch (NumberFormatException nfe) {
                JOptionPane.showMessageDialog(this, "All values must be positive integers", "Error", 0);
                return;
            }
            if (this.recplayActive.isSelected() && this.recplayDetail.isSelected() && this.replayDetail.isSelected()) {
                int pe;
                try {
                    pe = Integer.parseInt(this.replayPe.getText());
                }
                catch (NumberFormatException nfe) {
                    JOptionPane.showMessageDialog(this, "Only one processor may be selected", "Error", 0);
                    return;
                }
                if (pe < 0 || pe >= numberPes) {
                    JOptionPane.showMessageDialog(this, "The selected processor must be between 0 and the number of processors selected in the basic tab", "Error", 0);
                    return;
                }
            }
            this.exec.executable = this.filename.getText();
            this.exec.parameters = this.clParams.getText();
            this.exec.doNotSuspend = !this.suspendOnStart.isSelected();
            this.exec.npes = numberPes;
            this.exec.port = this.portno.getText();
            this.exec.sshport = sshportNumber;
            this.exec.hostname = this.hostname.getText();
            this.exec.username = this.username.getText();
            this.exec.inputFile = this.inputFile.getText();
            this.exec.waitFile = this.waitFile.isSelected();
            this.exec.sshTunnel = this.sshTunnel.isSelected();
            this.exec.workingDir = this.dir.getText();
            this.exec.virtualDebug = this.virtualDebug.isSelected();
            this.exec.virtualNpes = vPes;
            this.exec.recplayActive = this.recplayActive.isSelected();
            this.exec.recplayDetailActive = this.recplayDetail.isSelected();
            this.exec.record = this.record.isSelected();
            this.exec.replay = this.replay.isSelected();
            this.exec.recordDetail = this.recordDetail.isSelected();
            this.exec.replayDetail = this.replayDetail.isSelected();
            this.exec.selectedPes = "";
            if (this.recplayActive.isSelected() && this.recplayDetail.isSelected()) {
                if (this.recordDetail.isSelected()) {
                    this.exec.selectedPes = this.recordPes.getText();
                } else if (this.replayDetail.isSelected()) {
                    this.exec.selectedPes = this.replayPe.getText();
                }
            }
            if (this.recplayChecksum.isSelected()) {
                if (this.checksumXOR.isSelected()) {
                    this.exec.recplayChecksum = 1;
                } else if (this.checksumCRC.isSelected()) {
                    this.exec.recplayChecksum = 2;
                } else {
                    this.exec.recplayChecksum = 0;
                    JOptionPane.showMessageDialog(this, "Error", "The selected checksum option is not acceptable\nPlease contact a Charm++ developer", 0);
                }
            } else {
                this.exec.recplayChecksum = 0;
            }
            closeWindow = true;
        }
        if (closeWindow) {
            this.setVisible(false);
            this.dispose();
        }
    }

    private void enableRecplay() {
        boolean status = this.recplayActive.isSelected();
        Color color = status ? Color.BLACK : Color.GRAY;
        this.record.setEnabled(status);
        this.record.setForeground(color);
        this.replay.setEnabled(status);
        this.replay.setForeground(color);
        this.recplayChecksum.setEnabled(status);
        this.recplayChecksum.setForeground(color);
        status = status && this.replay.isSelected();
        color = status ? Color.BLACK : Color.GRAY;
        this.recplayDetail.setEnabled(status);
        this.recplayDetail.setForeground(color);
        status = this.recplayActive.isSelected() && this.recplayDetail.isSelected() && this.replay.isSelected();
        color = status ? Color.BLACK : Color.GRAY;
        this.recordDetail.setEnabled(status);
        this.recordDetail.setForeground(color);
        this.recordPes.setEnabled(status && this.recordDetail.isSelected());
        this.replayDetail.setEnabled(status);
        this.replayDetail.setForeground(color);
        this.replayPe.setEnabled(status && this.replayDetail.isSelected());
        status = this.recplayActive.isSelected() && this.recplayChecksum.isSelected();
        color = status ? Color.BLACK : Color.GRAY;
        this.checksumXOR.setEnabled(status);
        this.checksumXOR.setForeground(color);
        this.checksumCRC.setEnabled(status);
        this.checksumCRC.setForeground(color);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.virtualDebug) {
            if (this.virtualDebug.isSelected()) {
                this.virtualPeslabel.setForeground(Color.BLACK);
                this.virtualPes.setEnabled(true);
            } else {
                this.virtualPeslabel.setForeground(Color.GRAY);
                this.virtualPes.setEnabled(false);
            }
        } else if (e.getSource() == this.recplayActive || e.getSource() == this.recplayDetail || e.getSource() == this.replay || e.getSource() == this.recordDetail || e.getSource() == this.replayDetail || e.getSource() == this.recplayChecksum) {
            this.enableRecplay();
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(200, 100);
            }
        };
        frame.setTitle("Debugging frame");
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(false);
        ParamsDialog dialog = new ParamsDialog((Frame)frame, true, new Execution());
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                System.exit(0);
            }

            @Override
            public void windowClosed(WindowEvent event) {
                System.exit(0);
            }
        });
        dialog.pack();
        dialog.setVisible(true);
    }
}

