/***************************************************************************
 *                                                                         *
 *   clusterarr.h   (begin: Feb 20 2003)                                   *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh}@cs.uni-duesseldorf.de                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef CLUSTERARR_H
#define CLUSTERARR_H
#include "cluster.h"
#include "vec.h"
#include "clutree.h"

class ClusterArr {
public:
	int nDifCluster_;
	int totalNCluster_;
	int totalNCluTree_;
	int nSeq_;
	Vec<Cluster> items_;


	typedef Vec<int> IVec_;
	Vec<IVec_> indexArr_;
	Vec<int> majorClusterArr_;

	Vec<CluTree> cluTreeArr_;

	ClusterArr ();

	void add (Vec<int> &exNdNoLs, double brLen);

	void operator += (Cluster &cluster);
	Cluster &operator [] (int cNo);

	int findCluster (Cluster &cluster);

	void setupIndex ();

	//=====================================================
	int findClusterConTree (Cluster &cluster);

	//add cluster into cluster array
	void addConTree (Cluster &cluster);
	int findMajorCluster (int nDifTree);
	void findCluTree (int clusterNo, Vec<int> &cluTreeNoArr);
	void createNewClusterTree (int nDifTree, int clusterNo);
	int createConTree (int nDifTree, Vec<char> &conTree);

	void printSplits(int nDifTree, int outGrpSeqNo, const char *filename);


	void increaseSize();

	~ClusterArr ();
};
#endif
