/***************************************************************************
 *                                                                         *
 *   inndarr.h      (begin: Feb 20 2003)                                   *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2005 by Le Sy Vinh, Bui Quang Minh, Arndt von Haeseler  *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh,minh}@cs.uni-duesseldorf.de                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef INNDARR_H
#define INNDARR_H

#include "innd.h"

//this class is a collect of all internal nodes of the unrooted tree
class InNdArr {
public :

	//construction function
	InNdArr ();

	//construction function
	InNdArr (const int maxNInNd);

	//set the limit of this array
	void setLimit (const int maxNInNd);

	//get the number of currently existing in nodes
	int getCurNNd ();

	//get the maximum number nodes of this class
	int getMaxNNd ();

	//get the maximum number of external nodes
	int getMaxNExNd ();

	//return a new internal node
	int getNewNd ();

	//the data of internal node inNdNo is contained in the items_[inNdNo - maxNExNd]
	void setMaxNExNd (const int maxNExNd);

	int isExNd (const int ndNo);

	void getExDesNd (int parNdNo, int ndNo, Vec<int> &exDesNdNoLs);

	//add a new node
	void operator += (InNd &inNd);

	//del an existing in node
	void operator -= (const int ndNo);

	//return inNdArr[index]
	InNd &operator[] (const int index);

	//change the content of this item
	void changeItem (InNd &inNd);

	//this = inNdArr
	void operator = (InNdArr &inNdArr);

	//get the items list of this class
	Vec<InNd> &getItem ();

	//check whether or not the ndNo is an internal node
	int isInNd (const int ndNo);

	//clean the content of this array
	void clean ();

	//release all memmory for this class
	void release ();

	//destruction function
	~InNdArr ();

	/***********************************************************************
	***********************************************************************
	***********************************************************************
	***********************************************************************/
protected :
	//the number of currently existing nodes
	int curNInNd_;

	//the maximum number of internal nodes
	int maxNInNd_;

	//becase there is no internal node whose id is smaller than nExNod_
	int maxNExNd_;

	//list of in nodes
	Vec<InNd> items_;

}
; // end of inNdArr class
#endif
