package airec

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateExperimentStatus invokes the airec.UpdateExperimentStatus API synchronously
func (client *Client) UpdateExperimentStatus(request *UpdateExperimentStatusRequest) (response *UpdateExperimentStatusResponse, err error) {
	response = CreateUpdateExperimentStatusResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateExperimentStatusWithChan invokes the airec.UpdateExperimentStatus API asynchronously
func (client *Client) UpdateExperimentStatusWithChan(request *UpdateExperimentStatusRequest) (<-chan *UpdateExperimentStatusResponse, <-chan error) {
	responseChan := make(chan *UpdateExperimentStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateExperimentStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateExperimentStatusWithCallback invokes the airec.UpdateExperimentStatus API asynchronously
func (client *Client) UpdateExperimentStatusWithCallback(request *UpdateExperimentStatusRequest, callback func(response *UpdateExperimentStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateExperimentStatusResponse
		var err error
		defer close(result)
		response, err = client.UpdateExperimentStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateExperimentStatusRequest is the request struct for api UpdateExperimentStatus
type UpdateExperimentStatusRequest struct {
	*requests.RoaRequest
	InstanceId   string `position:"Path" name:"instanceId"`
	SceneId      string `position:"Path" name:"sceneId"`
	ExperimentId string `position:"Path" name:"experimentId"`
}

// UpdateExperimentStatusResponse is the response struct for api UpdateExperimentStatus
type UpdateExperimentStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
	Result    Result `json:"result" xml:"result"`
}

// CreateUpdateExperimentStatusRequest creates a request to invoke UpdateExperimentStatus API
func CreateUpdateExperimentStatusRequest() (request *UpdateExperimentStatusRequest) {
	request = &UpdateExperimentStatusRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Airec", "2020-11-26", "UpdateExperimentStatus", "/v2/openapi/instances/[instanceId]/scenes/[sceneId]/experiments/[experimentId]/status", "airec", "openAPI")
	request.Method = requests.PUT
	return
}

// CreateUpdateExperimentStatusResponse creates a response to parse from UpdateExperimentStatus response
func CreateUpdateExperimentStatusResponse() (response *UpdateExperimentStatusResponse) {
	response = &UpdateExperimentStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
