package alb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ReplaceServersInServerGroup invokes the alb.ReplaceServersInServerGroup API synchronously
func (client *Client) ReplaceServersInServerGroup(request *ReplaceServersInServerGroupRequest) (response *ReplaceServersInServerGroupResponse, err error) {
	response = CreateReplaceServersInServerGroupResponse()
	err = client.DoAction(request, response)
	return
}

// ReplaceServersInServerGroupWithChan invokes the alb.ReplaceServersInServerGroup API asynchronously
func (client *Client) ReplaceServersInServerGroupWithChan(request *ReplaceServersInServerGroupRequest) (<-chan *ReplaceServersInServerGroupResponse, <-chan error) {
	responseChan := make(chan *ReplaceServersInServerGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ReplaceServersInServerGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ReplaceServersInServerGroupWithCallback invokes the alb.ReplaceServersInServerGroup API asynchronously
func (client *Client) ReplaceServersInServerGroupWithCallback(request *ReplaceServersInServerGroupRequest, callback func(response *ReplaceServersInServerGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ReplaceServersInServerGroupResponse
		var err error
		defer close(result)
		response, err = client.ReplaceServersInServerGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ReplaceServersInServerGroupRequest is the request struct for api ReplaceServersInServerGroup
type ReplaceServersInServerGroupRequest struct {
	*requests.RpcRequest
	ClientToken    string                                       `position:"Query" name:"ClientToken"`
	ServerGroupId  string                                       `position:"Query" name:"ServerGroupId"`
	AddedServers   *[]ReplaceServersInServerGroupAddedServers   `position:"Query" name:"AddedServers"  type:"Repeated"`
	DryRun         requests.Boolean                             `position:"Query" name:"DryRun"`
	RemovedServers *[]ReplaceServersInServerGroupRemovedServers `position:"Query" name:"RemovedServers"  type:"Repeated"`
}

// ReplaceServersInServerGroupAddedServers is a repeated param struct in ReplaceServersInServerGroupRequest
type ReplaceServersInServerGroupAddedServers struct {
	RemoteIpEnabled string `name:"RemoteIpEnabled"`
	ServerType      string `name:"ServerType"`
	Port            string `name:"Port"`
	Description     string `name:"Description"`
	ServerIp        string `name:"ServerIp"`
	Weight          string `name:"Weight"`
	ServerId        string `name:"ServerId"`
}

// ReplaceServersInServerGroupRemovedServers is a repeated param struct in ReplaceServersInServerGroupRequest
type ReplaceServersInServerGroupRemovedServers struct {
	ServerType string `name:"ServerType"`
	Port       string `name:"Port"`
	ServerIp   string `name:"ServerIp"`
	ServerId   string `name:"ServerId"`
}

// ReplaceServersInServerGroupResponse is the response struct for api ReplaceServersInServerGroup
type ReplaceServersInServerGroupResponse struct {
	*responses.BaseResponse
	JobId     string `json:"JobId" xml:"JobId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateReplaceServersInServerGroupRequest creates a request to invoke ReplaceServersInServerGroup API
func CreateReplaceServersInServerGroupRequest() (request *ReplaceServersInServerGroupRequest) {
	request = &ReplaceServersInServerGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alb", "2020-06-16", "ReplaceServersInServerGroup", "alb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateReplaceServersInServerGroupResponse creates a response to parse from ReplaceServersInServerGroup response
func CreateReplaceServersInServerGroupResponse() (response *ReplaceServersInServerGroupResponse) {
	response = &ReplaceServersInServerGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
