package hbase

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeServerlessCluster invokes the hbase.DescribeServerlessCluster API synchronously
func (client *Client) DescribeServerlessCluster(request *DescribeServerlessClusterRequest) (response *DescribeServerlessClusterResponse, err error) {
	response = CreateDescribeServerlessClusterResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeServerlessClusterWithChan invokes the hbase.DescribeServerlessCluster API asynchronously
func (client *Client) DescribeServerlessClusterWithChan(request *DescribeServerlessClusterRequest) (<-chan *DescribeServerlessClusterResponse, <-chan error) {
	responseChan := make(chan *DescribeServerlessClusterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeServerlessCluster(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeServerlessClusterWithCallback invokes the hbase.DescribeServerlessCluster API asynchronously
func (client *Client) DescribeServerlessClusterWithCallback(request *DescribeServerlessClusterRequest, callback func(response *DescribeServerlessClusterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeServerlessClusterResponse
		var err error
		defer close(result)
		response, err = client.DescribeServerlessCluster(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeServerlessClusterRequest is the request struct for api DescribeServerlessCluster
type DescribeServerlessClusterRequest struct {
	*requests.RpcRequest
	ClusterId string `position:"Query" name:"ClusterId"`
	ZoneId    string `position:"Query" name:"ZoneId"`
}

// DescribeServerlessClusterResponse is the response struct for api DescribeServerlessCluster
type DescribeServerlessClusterResponse struct {
	*responses.BaseResponse
	RequestId            string `json:"RequestId" xml:"RequestId"`
	VpcId                string `json:"VpcId" xml:"VpcId"`
	VSwitchId            string `json:"VSwitchId" xml:"VSwitchId"`
	InstanceId           string `json:"InstanceId" xml:"InstanceId"`
	InstanceName         string `json:"InstanceName" xml:"InstanceName"`
	MainVersion          string `json:"MainVersion" xml:"MainVersion"`
	Status               string `json:"Status" xml:"Status"`
	ClusterType          string `json:"ClusterType" xml:"ClusterType"`
	HasUser              string `json:"HasUser" xml:"HasUser"`
	LockMode             string `json:"LockMode" xml:"LockMode"`
	HaType               string `json:"HaType" xml:"HaType"`
	PayType              string `json:"PayType" xml:"PayType"`
	InnerEndpoint        string `json:"InnerEndpoint" xml:"InnerEndpoint"`
	OuterEndpoint        string `json:"OuterEndpoint" xml:"OuterEndpoint"`
	ReserverMinQpsNum    string `json:"ReserverMinQpsNum" xml:"ReserverMinQpsNum"`
	ReserverMaxQpsNum    string `json:"ReserverMaxQpsNum" xml:"ReserverMaxQpsNum"`
	AutoRenew            string `json:"AutoRenew" xml:"AutoRenew"`
	CreateTime           string `json:"CreateTime" xml:"CreateTime"`
	ExpireTime           string `json:"ExpireTime" xml:"ExpireTime"`
	RegionId             string `json:"RegionId" xml:"RegionId"`
	ZoneId               string `json:"ZoneId" xml:"ZoneId"`
	UpdateStatus         string `json:"UpdateStatus" xml:"UpdateStatus"`
	IsDeletionProtection string `json:"IsDeletionProtection" xml:"IsDeletionProtection"`
	DiskSize             string `json:"DiskSize" xml:"DiskSize"`
	CuSize               string `json:"CuSize" xml:"CuSize"`
	ResourceGroupId      string `json:"ResourceGroupId" xml:"ResourceGroupId"`
}

// CreateDescribeServerlessClusterRequest creates a request to invoke DescribeServerlessCluster API
func CreateDescribeServerlessClusterRequest() (request *DescribeServerlessClusterRequest) {
	request = &DescribeServerlessClusterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("HBase", "2019-01-01", "DescribeServerlessCluster", "hbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeServerlessClusterResponse creates a response to parse from DescribeServerlessCluster response
func CreateDescribeServerlessClusterResponse() (response *DescribeServerlessClusterResponse) {
	response = &DescribeServerlessClusterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
