package linkwan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AcceptJoinPermissionAuthOrder invokes the linkwan.AcceptJoinPermissionAuthOrder API synchronously
func (client *Client) AcceptJoinPermissionAuthOrder(request *AcceptJoinPermissionAuthOrderRequest) (response *AcceptJoinPermissionAuthOrderResponse, err error) {
	response = CreateAcceptJoinPermissionAuthOrderResponse()
	err = client.DoAction(request, response)
	return
}

// AcceptJoinPermissionAuthOrderWithChan invokes the linkwan.AcceptJoinPermissionAuthOrder API asynchronously
func (client *Client) AcceptJoinPermissionAuthOrderWithChan(request *AcceptJoinPermissionAuthOrderRequest) (<-chan *AcceptJoinPermissionAuthOrderResponse, <-chan error) {
	responseChan := make(chan *AcceptJoinPermissionAuthOrderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AcceptJoinPermissionAuthOrder(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AcceptJoinPermissionAuthOrderWithCallback invokes the linkwan.AcceptJoinPermissionAuthOrder API asynchronously
func (client *Client) AcceptJoinPermissionAuthOrderWithCallback(request *AcceptJoinPermissionAuthOrderRequest, callback func(response *AcceptJoinPermissionAuthOrderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AcceptJoinPermissionAuthOrderResponse
		var err error
		defer close(result)
		response, err = client.AcceptJoinPermissionAuthOrder(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AcceptJoinPermissionAuthOrderRequest is the request struct for api AcceptJoinPermissionAuthOrder
type AcceptJoinPermissionAuthOrderRequest struct {
	*requests.RpcRequest
	OrderId     string `position:"Query" name:"OrderId"`
	ApiProduct  string `position:"Body" name:"ApiProduct"`
	ApiRevision string `position:"Body" name:"ApiRevision"`
}

// AcceptJoinPermissionAuthOrderResponse is the response struct for api AcceptJoinPermissionAuthOrder
type AcceptJoinPermissionAuthOrderResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateAcceptJoinPermissionAuthOrderRequest creates a request to invoke AcceptJoinPermissionAuthOrder API
func CreateAcceptJoinPermissionAuthOrderRequest() (request *AcceptJoinPermissionAuthOrderRequest) {
	request = &AcceptJoinPermissionAuthOrderRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkWAN", "2019-03-01", "AcceptJoinPermissionAuthOrder", "linkwan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAcceptJoinPermissionAuthOrderResponse creates a response to parse from AcceptJoinPermissionAuthOrder response
func CreateAcceptJoinPermissionAuthOrderResponse() (response *AcceptJoinPermissionAuthOrderResponse) {
	response = &AcceptJoinPermissionAuthOrderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
