package outboundbot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListGlobalQuestions invokes the outboundbot.ListGlobalQuestions API synchronously
func (client *Client) ListGlobalQuestions(request *ListGlobalQuestionsRequest) (response *ListGlobalQuestionsResponse, err error) {
	response = CreateListGlobalQuestionsResponse()
	err = client.DoAction(request, response)
	return
}

// ListGlobalQuestionsWithChan invokes the outboundbot.ListGlobalQuestions API asynchronously
func (client *Client) ListGlobalQuestionsWithChan(request *ListGlobalQuestionsRequest) (<-chan *ListGlobalQuestionsResponse, <-chan error) {
	responseChan := make(chan *ListGlobalQuestionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListGlobalQuestions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListGlobalQuestionsWithCallback invokes the outboundbot.ListGlobalQuestions API asynchronously
func (client *Client) ListGlobalQuestionsWithCallback(request *ListGlobalQuestionsRequest, callback func(response *ListGlobalQuestionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListGlobalQuestionsResponse
		var err error
		defer close(result)
		response, err = client.ListGlobalQuestions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListGlobalQuestionsRequest is the request struct for api ListGlobalQuestions
type ListGlobalQuestionsRequest struct {
	*requests.RpcRequest
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	ScriptId   string           `position:"Query" name:"ScriptId"`
	InstanceId string           `position:"Query" name:"InstanceId"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
}

// ListGlobalQuestionsResponse is the response struct for api ListGlobalQuestions
type ListGlobalQuestionsResponse struct {
	*responses.BaseResponse
	Code            string          `json:"Code" xml:"Code"`
	HttpStatusCode  int             `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message         string          `json:"Message" xml:"Message"`
	RequestId       string          `json:"RequestId" xml:"RequestId"`
	Success         bool            `json:"Success" xml:"Success"`
	GlobalQuestions GlobalQuestions `json:"GlobalQuestions" xml:"GlobalQuestions"`
}

// CreateListGlobalQuestionsRequest creates a request to invoke ListGlobalQuestions API
func CreateListGlobalQuestionsRequest() (request *ListGlobalQuestionsRequest) {
	request = &ListGlobalQuestionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OutboundBot", "2019-12-26", "ListGlobalQuestions", "outboundbot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListGlobalQuestionsResponse creates a response to parse from ListGlobalQuestions response
func CreateListGlobalQuestionsResponse() (response *ListGlobalQuestionsResponse) {
	response = &ListGlobalQuestionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
