/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.impl.schema;

import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.Stack;
import com.intellij.xml.XmlElementsGroup;
import com.intellij.xml.impl.schema.XmlElementsGroupImpl;
import com.intellij.xml.impl.schema.XmlElementsGroupLeaf;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import com.intellij.xml.impl.schema.XmlSchemaTagsProcessor;

public final class XmlElementsGroupProcessor
extends XmlSchemaTagsProcessor {
    final Stack<XmlElementsGroup> myGroups = new Stack();

    public static XmlElementsGroup computeGroups(XmlNSDescriptorImpl descriptor, XmlTag tag) {
        XmlElementsGroupProcessor processor = new XmlElementsGroupProcessor(descriptor);
        processor.startProcessing(tag);
        return processor.getRootGroup();
    }

    private XmlElementsGroup getRootGroup() {
        return (XmlElementsGroup)this.myGroups.get(0);
    }

    private XmlElementsGroupProcessor(XmlNSDescriptorImpl nsDescriptor) {
        super(nsDescriptor, "attribute");
        this.myGroups.push((Object)new XmlElementsGroupImpl(this, null, null, null){

            @Override
            public XmlElementsGroup.Type getGroupType() {
                return XmlElementsGroup.Type.GROUP;
            }

            @Override
            public String toString() {
                return "root";
            }
        });
    }

    @Override
    protected void tagStarted(XmlTag tag, String tagName, XmlTag context, XmlTag ref) {
        XmlElementsGroup.Type type = XmlElementsGroupImpl.getTagType(tag);
        if (type != null) {
            XmlElementsGroupImpl group = new XmlElementsGroupImpl(tag, (XmlElementsGroup)this.myGroups.peek(), ref);
            this.addSubGroup(group);
            this.myGroups.push((Object)group);
        } else if ("element".equals(tagName)) {
            XmlElementsGroupLeaf group = new XmlElementsGroupLeaf(tag, this.myNsDescriptor.createElementDescriptor(tag), (XmlElementsGroup)this.myGroups.peek(), ref);
            if (!this.myGroups.empty()) {
                this.addSubGroup(group);
            } else {
                this.myGroups.push((Object)group);
            }
        }
    }

    @Override
    protected void tagFinished(XmlTag tag) {
        if (!this.myGroups.empty() && XmlElementsGroupImpl.getTagType(tag) != null) {
            this.myGroups.pop();
        }
    }

    private void addSubGroup(XmlElementsGroup group) {
        XmlElementsGroup last;
        if (!this.myGroups.empty() && (last = (XmlElementsGroup)this.myGroups.peek()) instanceof XmlElementsGroupImpl) {
            ((XmlElementsGroupImpl)last).addSubGroup(group);
        }
    }
}

