/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.model;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.kubernetes.KubernetesUtilKt;
import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.model.JointMapResourceDataAdapter;
import com.intellij.kubernetes.model.KubernetesResourceReferenceType;
import com.intellij.kubernetes.model.MapResourceDefinitionsKt;
import com.intellij.kubernetes.model.QueryJointMapResourcesCSS;
import com.intellij.kubernetes.references.KubernetesMapResourceReference;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import io.kubernetes.client.common.KubernetesObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.meta.model.CompletionContext;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001b\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J \u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u000e2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J \u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016*\b\u0012\u0004\u0012\u00028\u00000\u00072\u0006\u0010\u0018\u001a\u00020\u000eH\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/kubernetes/model/MapResourceReferenceType;", "T", "Lio/kubernetes/client/common/KubernetesObject;", "Lcom/intellij/kubernetes/model/KubernetesResourceReferenceType;", "typeName", "", "dataAdapter", "Lcom/intellij/kubernetes/model/JointMapResourceDataAdapter;", "<init>", "(Ljava/lang/String;Lcom/intellij/kubernetes/model/JointMapResourceDataAdapter;)V", "getReferencesFromValue", "", "Lcom/intellij/psi/PsiReference;", "valueScalar", "Lorg/jetbrains/yaml/psi/YAMLScalar;", "(Lorg/jetbrains/yaml/psi/YAMLScalar;)[Lcom/intellij/psi/PsiReference;", "validateScalarValue", "", "scalarValue", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "getValueLookups", "", "Lcom/intellij/codeInsight/lookup/LookupElement;", "insertedScalar", "completionContext", "Lorg/jetbrains/yaml/meta/model/CompletionContext;", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nMapResourceDefinitions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapResourceDefinitions.kt\ncom/intellij/kubernetes/model/MapResourceReferenceType\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,640:1\n1617#2,9:641\n1869#2:650\n1870#2:653\n1626#2:654\n1634#2,3:655\n1617#2,9:658\n1869#2:667\n1870#2:669\n1626#2:670\n1634#2,3:671\n1#3:651\n1#3:652\n1#3:668\n*S KotlinDebug\n*F\n+ 1 MapResourceDefinitions.kt\ncom/intellij/kubernetes/model/MapResourceReferenceType\n*L\n548#1:641,9\n548#1:650\n548#1:653\n548#1:654\n549#1:655,3\n552#1:658,9\n552#1:667\n552#1:669\n552#1:670\n553#1:671,3\n548#1:652\n552#1:668\n*E\n"})
public class MapResourceReferenceType<T extends KubernetesObject>
extends KubernetesResourceReferenceType {
    @NotNull
    private final JointMapResourceDataAdapter<T> dataAdapter;

    public MapResourceReferenceType(@NotNull String typeName, @NotNull JointMapResourceDataAdapter<T> dataAdapter) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        Intrinsics.checkNotNullParameter(dataAdapter, (String)"dataAdapter");
        super(dataAdapter.getResourceKind(), typeName);
        this.dataAdapter = dataAdapter;
    }

    @NotNull
    public PsiReference[] getReferencesFromValue(@NotNull YAMLScalar valueScalar) {
        Intrinsics.checkNotNullParameter((Object)valueScalar, (String)"valueScalar");
        PsiReference[] psiReferenceArray = new PsiReference[]{new KubernetesMapResourceReference<T>(valueScalar, this.dataAdapter)};
        return psiReferenceArray;
    }

    protected void validateScalarValue(@NotNull YAMLScalar scalarValue, @NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)scalarValue, (String)"scalarValue");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        String mapName = YamlUtilKt.getEffectiveText((YAMLValue)((YAMLValue)scalarValue));
        Project project = scalarValue.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Pair<Collection<YAMLMapping>, List<T>> pair = QueryJointMapResourcesCSS.Companion.getInstance(project).queryJointMapObjects((PsiElement)scalarValue, this.dataAdapter, mapName, 0L);
        Collection mapObjectsInSources = (Collection)pair.component1();
        List mapObjectsInCluster = (List)pair.component2();
        if (mapObjectsInSources.isEmpty() && mapObjectsInCluster.isEmpty()) {
            Object[] objectArray = new Object[]{this.getResourceKind()};
            holder.registerProblem((PsiElement)scalarValue, KubernetesBundle.message((String)"MapObjectDefinitions.resource.not.found", (Object[])objectArray), ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[0]);
        }
    }

    @NotNull
    public List<LookupElement> getValueLookups(@NotNull YAMLScalar insertedScalar, @Nullable CompletionContext completionContext) {
        Intrinsics.checkNotNullParameter((Object)insertedScalar, (String)"insertedScalar");
        return CollectionsKt.toMutableList((Collection)this.getValueLookups(this.dataAdapter, insertedScalar));
    }

    /*
     * WARNING - void declaration
     */
    private final List<LookupElement> getValueLookups(JointMapResourceDataAdapter<T> $this$getValueLookups, YAMLScalar insertedScalar) {
        void it;
        Collection collection;
        Iterable $this$mapTo$iv;
        YAMLMapping it2;
        boolean bl;
        Object element$iv$iv;
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Project project = insertedScalar.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Pair<Collection<YAMLMapping>, List<T>> pair = QueryJointMapResourcesCSS.Companion.getInstance(project).queryJointMapObjects((PsiElement)insertedScalar, $this$getValueLookups, null, 5000L);
        Collection mapObjectsInSources = (Collection)pair.component1();
        List mapObjectsInCluster = (List)pair.component2();
        List result2 = new ArrayList();
        Iterable iterable = mapObjectsInSources;
        boolean $i$f$mapNotNull = false;
        void var9_12 = $this$mapNotNull$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        String $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            element$iv$iv = element$iv$iv$iv = iterator.next();
            bl = false;
            it2 = (YAMLMapping)element$iv$iv;
            boolean bl2 = false;
            Object object2 = KubernetesUtilKt.findK8sResourceObjectName(it2);
            if (object2 != null && (object2 = YamlUtilKt.getEffectiveValueText((YAMLKeyValue)object2)) != null) {
                Object object3;
                Object p0 = object3 = object2;
                boolean bl3 = false;
                object = !StringsKt.isBlank((CharSequence)((CharSequence)p0)) ? object3 : null;
            } else {
                object = null;
            }
            if (object == null) continue;
            Object it$iv$iv = object;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        Collection destination$iv = result2;
        boolean $i$f$mapTo22 = false;
        for (Object item$iv : $this$mapTo$iv) {
            $this$forEach$iv$iv$iv = (String)item$iv;
            collection = destination$iv;
            boolean bl5 = false;
            collection.add(LookupElementBuilder.create((String)it));
        }
        $this$mapTo$iv = mapObjectsInCluster;
        $i$f$mapNotNull = false;
        Iterable $i$f$mapTo22 = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            element$iv$iv = element$iv$iv$iv = iterator.next();
            bl = false;
            it2 = (KubernetesObject)element$iv$iv;
            boolean bl6 = false;
            if (it2.getMetadata().getName() == null) continue;
            boolean bl7 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        destination$iv = result2;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            $this$forEach$iv$iv$iv = (String)item$iv;
            collection = destination$iv;
            boolean bl8 = false;
            collection.add(LookupElementBuilder.create((String)it).withItemTextForeground(MapResourceDefinitionsKt.access$getInClusterObjectIndication$p()));
        }
        return result2;
    }
}

