/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0016\u0018\u0000 '2\u00020\u0001:\u0001'B'\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\f\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0004J\b\u0010\u001b\u001a\u00020\u0005H\u0016J\u0006\u0010\u001c\u001a\u00020\u0005J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0014J\u000e\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0010J\u0006\u0010#\u001a\u00020\u0005J\u0016\u0010$\u001a\u00020\u00012\u0006\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u001f\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0014\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010 \u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010!\u00a8\u0006("}, d2={"Lcom/intellij/lang/javascript/DialectOptionHolder;", "", "name", "", "isTypeScript", "", "isECMA6", "<init>", "(Ljava/lang/String;ZZ)V", "isECMA4", "isFlow", "isTSX", "isQML", "hasE4X", "features", "", "Lcom/intellij/lang/javascript/dialects/JSLanguageFeature;", "getFeatures", "()Ljava/util/Set;", "features$delegate", "Lkotlin/Lazy;", "lexerConstructor", "Ljava/lang/reflect/Constructor;", "getLexerConstructor", "()Ljava/lang/reflect/Constructor;", "lexerConstructor$delegate", "findLexerClass", "hasJSSyntax", "supportsTypeGuard", "defineFeatures", "hasFeature", "feature", "isJSX", "()Z", "isJavaScript", "hasE4XStandard", "createLexer", "highlightMode", "jsDocTypesMode", "Companion", "intellij.javascript.parser"})
public class DialectOptionHolder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @JvmField
    public final boolean isTypeScript;
    @JvmField
    public final boolean isECMA4;
    @JvmField
    public final boolean isFlow;
    @JvmField
    public final boolean isTSX;
    @JvmField
    public final boolean isQML;
    private final boolean hasE4X;
    @JvmField
    public final boolean isECMA6;
    @NotNull
    private final Lazy features$delegate;
    @NotNull
    private final Lazy lexerConstructor$delegate;
    @JvmField
    @NotNull
    public static final DialectOptionHolder ECMA_4 = new DialectOptionHolder("ECMA_4", false, false, 6, null);
    @JvmField
    @NotNull
    public static final DialectOptionHolder JS_WITH_JSX = new DialectOptionHolder("JSX", false, false, 6, null);
    @JvmField
    @NotNull
    public static final DialectOptionHolder JS_WITHOUT_JSX = new DialectOptionHolder("ECMA_6", false, false, 6, null);
    @JvmField
    @NotNull
    public static final DialectOptionHolder JS_1_5 = new DialectOptionHolder("JS_1_5", false, false, 6, null);
    @JvmField
    @NotNull
    public static final DialectOptionHolder TS = new DialectOptionHolder("TS", true, false, 4, null);
    @JvmField
    @NotNull
    public static final DialectOptionHolder TSX = new DialectOptionHolder("TSX", true, false, 4, null);
    @JvmField
    @NotNull
    public static final DialectOptionHolder FLOW = new DialectOptionHolder("FLOW", false, false, 6, null);
    @JvmField
    @NotNull
    public static final DialectOptionHolder OTHER = new DialectOptionHolder("OTHER", false, false, 6, null);

    @JvmOverloads
    public DialectOptionHolder(@NonNls @NotNull String name, boolean isTypeScript, boolean isECMA6) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.isTypeScript = isTypeScript;
        this.isECMA4 = Intrinsics.areEqual((Object)this.name, (Object)"ECMA_4");
        this.isFlow = Intrinsics.areEqual((Object)this.name, (Object)"FLOW");
        this.isTSX = Intrinsics.areEqual((Object)this.name, (Object)"TSX");
        this.isQML = Intrinsics.areEqual((Object)this.name, (Object)"QmlLang");
        this.hasE4X = Intrinsics.areEqual((Object)this.name, (Object)"E4X") || Intrinsics.areEqual((Object)this.name, (Object)"JSX") || this.isFlow || this.isTSX;
        this.isECMA6 = isECMA6 || Intrinsics.areEqual((Object)this.name, (Object)"ECMA_6") || this.isFlow || this.isQML || Intrinsics.areEqual((Object)this.name, (Object)"JSX") || Intrinsics.areEqual((Object)this.name, (Object)"JS_1_6") || Intrinsics.areEqual((Object)this.name, (Object)"JS_1_7") || Intrinsics.areEqual((Object)this.name, (Object)"JS_1_8");
        this.features$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Set<? extends JSLanguageFeature>>((Object)this){

            public final Set<JSLanguageFeature> invoke() {
                return ((DialectOptionHolder)this.receiver).defineFeatures();
            }
        }));
        this.lexerConstructor$delegate = LazyKt.lazy((Function0)new Function0<Constructor<?>>(this){

            public final Constructor<?> invoke() {
                return ((DialectOptionHolder)this.receiver).findLexerClass();
            }
        });
    }

    public /* synthetic */ DialectOptionHolder(String string, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        this(string, bl, bl2);
    }

    private final Set<JSLanguageFeature> getFeatures() {
        Lazy lazy = this.features$delegate;
        return (Set)lazy.getValue();
    }

    private final Constructor<?> getLexerConstructor() {
        Lazy lazy = this.lexerConstructor$delegate;
        return (Constructor)lazy.getValue();
    }

    @NotNull
    protected final Constructor<?> findLexerClass() {
        try {
            Class[] classArray = new Class[]{Reader.class, Boolean.TYPE, Boolean.TYPE};
            Constructor<?> constructor = Class.forName("com.intellij.lang.javascript._" + this.name + "Lexer").getConstructor(classArray);
            Intrinsics.checkNotNullExpressionValue(constructor, (String)"getConstructor(...)");
            return constructor;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean hasJSSyntax() {
        return true;
    }

    public final boolean supportsTypeGuard() {
        return this.hasJSSyntax() && !this.isECMA4;
    }

    @NotNull
    protected Set<JSLanguageFeature> defineFeatures() {
        EnumSet<JSLanguageFeature> features2 = EnumSet.noneOf(JSLanguageFeature.class);
        if (this.hasE4X || this.isECMA4) {
            features2.add(JSLanguageFeature.E4X);
        }
        if (this.isECMA4) {
            features2.add(JSLanguageFeature.FOR_EACH);
        }
        if (this.isECMA6 || this.isTypeScript) {
            features2.add(JSLanguageFeature.FOR_OF);
        }
        if (this.isECMA6 || this.isTypeScript) {
            features2.add(JSLanguageFeature.LET_DEFINITIONS);
            features2.add(JSLanguageFeature.CONST_DEFINITIONS);
        }
        if (this.isECMA6 || this.isTypeScript) {
            features2.add(JSLanguageFeature.YIELD_GENERATORS);
        }
        if (this.isECMA6 || this.isTypeScript) {
            features2.add(JSLanguageFeature.DESTRUCTURING_ASSIGNMENT);
        }
        if (this.isECMA6 || this.isTypeScript) {
            features2.add(JSLanguageFeature.DESTRUCTURING_PARAMETERS);
        }
        features2.add(JSLanguageFeature.ACCESSORS);
        if (this.isECMA6 || this.isTypeScript) {
            features2.add(JSLanguageFeature.ARROW_FUNCTIONS);
        }
        if (this.isECMA4 || this.isECMA6 || this.isTypeScript) {
            features2.add(JSLanguageFeature.REST_PARAMETERS);
        }
        if (this.isTypeScript || this.isFlow) {
            features2.add(JSLanguageFeature.GENERICS);
        }
        if (this.isECMA6 || this.isTypeScript) {
            features2.add(JSLanguageFeature.IMPORT_DECLARATIONS);
        }
        if (this.isECMA6 || this.isTypeScript) {
            features2.add(JSLanguageFeature.EXPORT_DECLARATIONS);
        }
        if (this.isECMA4 || this.isTypeScript || this.isECMA6) {
            features2.add(JSLanguageFeature.CLASSES);
        }
        if (this.isECMA6 || this.isTypeScript) {
            features2.add(JSLanguageFeature.ANNOTATIONS);
            features2.add(JSLanguageFeature.ASYNC_AWAIT);
            features2.add(JSLanguageFeature.SHORTHAND_PROPERTY_NAMES);
            features2.add(JSLanguageFeature.COMPUTED_PROPERTY_NAMES);
            features2.add(JSLanguageFeature.METHOD_DEFINITION_SHORTHANDS);
        }
        if (this.isECMA6 || this.isTypeScript) {
            features2.add(JSLanguageFeature.BINARY_AND_OCTAL_LITERALS);
            features2.add(JSLanguageFeature.STRING_TEMPLATES);
        }
        if (this.isECMA6) {
            features2.add(JSLanguageFeature.BIND_EXPRESSIONS);
            features2.add(JSLanguageFeature.UNICODE_ESCAPES_WITH_BRACES);
        }
        if (this.isFlow || this.isTypeScript || this.isECMA4) {
            features2.add(JSLanguageFeature.TYPES);
            features2.add(JSLanguageFeature.INTERFACES);
        }
        if (this.isFlow || this.isTypeScript || this.isECMA6) {
            features2.add(JSLanguageFeature.TRAILING_FUNCTION_COMMA);
            features2.add(JSLanguageFeature.OPTIONAL_CATCH_BINDING);
        }
        if (this.isECMA6) {
            if (!this.isFlow) {
                features2.add(JSLanguageFeature.BIG_INT);
                features2.add(JSLanguageFeature.OPTIONAL_CHAINING_OPERATOR);
            }
            features2.add(JSLanguageFeature.PRIVATE_SHARP_SYNTAX);
            features2.add(JSLanguageFeature.THROW_EXPRESSIONS);
            features2.add(JSLanguageFeature.DECORATOR_DECLARATIONS);
            features2.add(JSLanguageFeature.PIPE_EXPRESSIONS);
        }
        if (this.isTypeScript) {
            features2.add(JSLanguageFeature.BIG_INT);
            features2.add(JSLanguageFeature.PRIVATE_SHARP_SYNTAX);
        }
        if (this.isTypeScript || this.isECMA4 || this.isFlow) {
            features2.add(JSLanguageFeature.VISIBILITY_MODIFIERS);
        }
        if (this.isTypeScript || this.isECMA4 || this.isECMA6) {
            features2.add(JSLanguageFeature.PARAMETER_INITIALIZERS);
        }
        if (this.isTypeScript || this.isFlow) {
            features2.add(JSLanguageFeature.ENUMS);
        }
        if (this.isECMA6 || this.isTypeScript) {
            features2.add(JSLanguageFeature.NULLISH_COALESCING);
        }
        Set<JSLanguageFeature> set = Collections.unmodifiableSet((Set)features2);
        Intrinsics.checkNotNullExpressionValue(set, (String)"unmodifiableSet(...)");
        return set;
    }

    public final boolean hasFeature(@NotNull JSLanguageFeature feature) {
        Intrinsics.checkNotNullParameter((Object)((Object)feature), (String)"feature");
        return this.getFeatures().contains((Object)feature);
    }

    public boolean isJSX() {
        return this.isTSX || this.isFlow || Intrinsics.areEqual((Object)"JSX", (Object)this.name);
    }

    public final boolean isJavaScript() {
        return this != ECMA_4 && !this.isTypeScript && this != OTHER;
    }

    public final boolean hasE4XStandard() {
        return this.isECMA4;
    }

    @NotNull
    public final Object createLexer(boolean highlightMode, boolean jsDocTypesMode) {
        try {
            Object[] objectArray = new Object[]{null, highlightMode, jsDocTypesMode};
            Object obj = this.getLexerConstructor().newInstance(objectArray);
            Intrinsics.checkNotNullExpressionValue(obj, (String)"newInstance(...)");
            return obj;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @JvmOverloads
    public DialectOptionHolder(@NonNls @NotNull String name, boolean isTypeScript) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this(name, isTypeScript, false, 4, null);
    }

    @JvmOverloads
    public DialectOptionHolder(@NonNls @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this(name, false, false, 6, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/lang/javascript/DialectOptionHolder$Companion;", "", "<init>", "()V", "ECMA_4", "Lcom/intellij/lang/javascript/DialectOptionHolder;", "JS_WITH_JSX", "JS_WITHOUT_JSX", "JS_1_5", "TS", "TSX", "FLOW", "OTHER", "intellij.javascript.parser"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

