/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.Dbms;
import com.intellij.database.model.ModelLightCopier;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDataObject;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.WeakInterner;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModelEntityStorage {
    private static final Logger LOG = Logger.getInstance(ModelEntityStorage.class);
    private static final Map<BasicMetaModel<?>, BasicInterner> ourInterners = ConcurrentFactoryMap.create(c2 -> new BasicInterner(), () -> CollectionFactory.createConcurrentWeakValueMap());
    private final AtomicInteger myIdAllocator;
    @NotNull
    private final BasicInterner myInterner;
    private volatile Backend myBackend;
    private Info myInfo;
    public static final Backend NO_OP = new NoOpBackend();

    public ModelEntityStorage(@NotNull BasicMetaModel<?> metaModel, @NotNull Backend backend) {
        if (metaModel == null) {
            ModelEntityStorage.$$$reportNull$$$0(0);
        }
        if (backend == null) {
            ModelEntityStorage.$$$reportNull$$$0(1);
        }
        this.myIdAllocator = new AtomicInteger(1);
        this.myInterner = ourInterners.get(metaModel);
        this.myBackend = backend;
        Info info = this.myBackend.loadInfo();
        this.myInfo = info == null ? new Info() : info;
    }

    public boolean isPersistent() {
        return this.myBackend.isPersistent();
    }

    @Nullable
    public BasicDataObject getDataObject(int entityId, @NotNull BasicMetaObject<?> meta) {
        if (meta == null) {
            ModelEntityStorage.$$$reportNull$$$0(2);
        }
        BasicDataObject res = this.myBackend.getDataObject(entityId, meta);
        this.updateDbms(entityId, res);
        return res == null ? null : this.myInterner.intern(res);
    }

    @Nullable
    public BasicDataObject setDataObject(int entityId, int parentEntityId, @Nullable BasicDataObject entity) {
        BasicDataObject frozen = entity == null || entity.isFrozen() ? entity : this.myInterner.intern(entity);
        this.myBackend.setDataObject(entityId, parentEntityId, frozen);
        this.updateDbms(entityId, frozen);
        return frozen;
    }

    private void updateDbms(int entityId, BasicDataObject res) {
        if (entityId != this.rootEntityId()) {
            return;
        }
        this.storeDbms(res instanceof BasicRoot ? ((BasicRoot)((Object)res)).getDbms() : null);
    }

    private void storeDbms(@Nullable Dbms dbms) {
        String name;
        String string = name = dbms == null ? null : dbms.getName();
        if (Objects.equals(this.myInfo.dbms, name)) {
            return;
        }
        this.myInfo.dbms = name;
        this.setVersion(this.myInfo.version);
    }

    public int allocateEntityId() {
        int id;
        while (this.myBackend.contains(id = this.myIdAllocator.incrementAndGet())) {
        }
        this.setVersion(this.myInfo.version);
        return id;
    }

    public int getVersion() {
        return this.myInfo.version;
    }

    public void setVersion(int version) {
        this.myInfo.version = version;
        this.myInfo.idCurrentValue = this.myIdAllocator.intValue();
        this.myBackend.storeInfo(this.myInfo);
    }

    public <V> boolean processHierarchy(int rootEntityId, V root, @NotNull HProcessor<V> processor) {
        if (processor == null) {
            ModelEntityStorage.$$$reportNull$$$0(3);
        }
        return this.myBackend.processHierarchy(rootEntityId, root, processor);
    }

    public int rootEntityId() {
        return 0;
    }

    public void clear() {
        this.myBackend.clear();
        this.myIdAllocator.set(1);
        this.myInfo = new Info();
    }

    public void moveEntities(Backend backend) {
        Backend prev = this.myBackend;
        try {
            backend.clear();
        }
        catch (Throwable th) {
            LOG.warn("Clear failed", th);
        }
        prev.moveEntities(backend);
        this.myBackend = backend;
        if (prev instanceof Disposable) {
            Disposer.dispose((Disposable)((Disposable)prev));
        }
    }

    public void shelve() {
        this.myBackend.shelve();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backend";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/model/ModelEntityStorage";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getDataObject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processHierarchy";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class BasicInterner
    extends WeakInterner<BasicDataObject> {
        public BasicInterner() {
            super((HashingStrategy)new HashingStrategy<BasicDataObject>(){

                public int hashCode(BasicDataObject object) {
                    return ModelLightCopier.hashCode(object);
                }

                public boolean equals(BasicDataObject o1, BasicDataObject o2) {
                    return ModelLightCopier.equals(o1, o2);
                }
            });
        }

        @NotNull
        public BasicDataObject intern(@NotNull BasicDataObject name) {
            if (name == null) {
                BasicInterner.$$$reportNull$$$0(0);
            }
            if (!name.freeze()) {
                BasicDataObject basicDataObject = name;
                if (basicDataObject == null) {
                    BasicInterner.$$$reportNull$$$0(1);
                }
                return basicDataObject;
            }
            BasicDataObject basicDataObject = (BasicDataObject)super.intern((Object)name);
            if (basicDataObject == null) {
                BasicInterner.$$$reportNull$$$0(2);
            }
            return basicDataObject;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/ModelEntityStorage$BasicInterner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/ModelEntityStorage$BasicInterner";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "intern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "intern";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    public static interface Backend {
        @Nullable
        public BasicDataObject getDataObject(int var1, @NotNull BasicMetaObject<?> var2);

        public void setDataObject(int var1, int var2, @Nullable BasicDataObject var3);

        public boolean contains(int var1);

        @Nullable
        public Info loadInfo();

        public void storeInfo(@Nullable Info var1);

        public boolean isPersistent();

        public <V> boolean processHierarchy(int var1, @Nullable V var2, HProcessor<V> var3);

        public void clear();

        public void moveEntities(@NotNull Backend var1);

        public void shelve();
    }

    public static class Info {
        public String dbms;
        public int version;
        public int idCurrentValue;
    }

    public static interface HProcessor<V> {
        public void process(@NotNull List<? extends Child> var1, @Nullable V var2, @NotNull BiConsumer<Child, V> var3);

        public static interface Child {
            public int getEntityId();

            public ObjectKind getObjectKind();

            public Object getStub();

            public long getObjectId();
        }
    }

    public static class NoOpBackend
    implements Backend {
        @Override
        @Nullable
        public BasicDataObject getDataObject(int entityId, @NotNull BasicMetaObject<?> meta) {
            if (meta == null) {
                NoOpBackend.$$$reportNull$$$0(0);
            }
            return null;
        }

        @Override
        public void setDataObject(int entityId, int parentEntityId, @Nullable BasicDataObject entity) {
        }

        @Override
        @Nullable
        public Info loadInfo() {
            return null;
        }

        @Override
        public void storeInfo(@Nullable Info info) {
        }

        @Override
        public boolean isPersistent() {
            return false;
        }

        @Override
        public <V> boolean processHierarchy(int rootEntityId, @Nullable V root, HProcessor<V> processor) {
            return false;
        }

        @Override
        public void clear() {
        }

        @Override
        public boolean contains(int entityId) {
            return false;
        }

        @Override
        public void moveEntities(@NotNull Backend backend) {
            if (backend == null) {
                NoOpBackend.$$$reportNull$$$0(1);
            }
        }

        @Override
        public void shelve() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "meta";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "backend";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/model/ModelEntityStorage$NoOpBackend";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getDataObject";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "moveEntities";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

