/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.monitor;

import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.dependency.fest_reflect.core.Reflection;

class ProtectingTimerTask
extends TimerTask {
    private static final int CANCELED = 3;
    private static Logger logger = Logger.getLogger(ProtectingTimerTask.class.getCanonicalName());
    private final TimerTask task;

    ProtectingTimerTask(TimerTask task) {
        this.task = task;
    }

    @Override
    public void run() {
        if (this.isCanceled()) {
            this.cancel();
            return;
        }
        try {
            this.task.run();
        }
        catch (Throwable thrown) {
            this.handleException(thrown);
        }
    }

    private boolean isCanceled() {
        try {
            int state = (Integer)Preconditions.checkNotNull((Object)Reflection.field("state").ofType(Integer.TYPE).in(this.task).get());
            return state == 3;
        }
        catch (RuntimeException e) {
            this.handleException(e);
            return false;
        }
    }

    private void handleException(Throwable thrown) {
        logger.log(Level.WARNING, "Exception thrown by a TimerTask", thrown);
    }
}

