/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.config.yaml;

import com.intellij.microservices.jvm.config.yaml.ConfigYamlUtils;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.quarkus.config.QsConfigUtils;
import com.intellij.quarkus.config.profiles.QsProfileTarget;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/quarkus/config/yaml/QsYamlUtils;", "", "<init>", "()V", "isInsideApplicationYamlFile", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "getQualifiedConfigKeyName", "", "yamlKeyValue", "Lorg/jetbrains/yaml/psi/YAMLKeyValue;", "getProfiles", "", "Lcom/intellij/quarkus/config/profiles/QsProfileTarget;", "document", "Lorg/jetbrains/yaml/psi/YAMLDocument;", "intellij.quarkus.config.yaml"})
public final class QsYamlUtils {
    @NotNull
    public static final QsYamlUtils INSTANCE = new QsYamlUtils();

    private QsYamlUtils() {
    }

    public final boolean isInsideApplicationYamlFile(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        PsiFile psiFile = psiElement.getContainingFile();
        if (psiFile == null) {
            return false;
        }
        PsiFile containingFile = psiFile;
        PsiFile psiFile2 = containingFile.getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getOriginalFile(...)");
        PsiFile originalFile = psiFile2;
        return originalFile instanceof YAMLFile && QsConfigUtils.INSTANCE.isConfigFile(originalFile);
    }

    @NotNull
    public final String getQualifiedConfigKeyName(@Nullable YAMLKeyValue yamlKeyValue) {
        String string = ConfigYamlUtils.getQualifiedConfigKeyName((YAMLKeyValue)yamlKeyValue, QsYamlUtils::getQualifiedConfigKeyName$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getQualifiedConfigKeyName(...)");
        return string;
    }

    @NotNull
    public final Collection<QsProfileTarget> getProfiles(@NotNull YAMLDocument document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        YAMLValue yAMLValue = document.getTopLevelValue();
        YAMLMapping yAMLMapping = yAMLValue instanceof YAMLMapping ? (YAMLMapping)yAMLValue : null;
        if (yAMLMapping == null) {
            return CollectionsKt.emptyList();
        }
        YAMLMapping searchElement = yAMLMapping;
        List result = (List)new SmartList();
        for (YAMLKeyValue keyValue : searchElement.getKeyValues()) {
            PsiReference profileReference;
            Intrinsics.checkNotNull((Object)keyValue);
            if (QsConfigUtils.INSTANCE.createProfileReference((PsiElement)keyValue) == null || profileReference.getRangeInElement().isEmpty()) continue;
            PsiElement psiElement = profileReference.getElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
            TextRange textRange = profileReference.getRangeInElement();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getRangeInElement(...)");
            result.add(new QsProfileTarget(psiElement, textRange));
        }
        return result;
    }

    private static final String getQualifiedConfigKeyName$lambda$0(YAMLKeyValue it) {
        String string;
        String string2 = it.getKeyText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getKeyText(...)");
        String keyText = string2;
        if (StringsKt.contains$default((CharSequence)keyText, (char)'.', (boolean)false, (int)2, null)) {
            string = it.getKey();
            if (string == null || (string = string.getText()) == null) {
                string = keyText;
            }
        } else {
            string = keyText;
        }
        return string;
    }
}

