/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate.model.enums;

import com.intellij.util.xml.NamedEnum;
import org.jetbrains.annotations.NonNls;

public enum HibernateTypeType implements NamedEnum
{
    INTEGER("integer"),
    LONG("long"),
    SHORT("short"),
    FLOAT("float"),
    DOUBLE("double"),
    CHARACTER("character"),
    BYTE("byte"),
    BOOLEAN("boolean"),
    YES_NO("yes_no"),
    TRUE_FALSE("true_false"),
    STRING("string"),
    DATE("date"),
    TIME("time"),
    TIMESTAMP("timestamp"),
    CALENDAR("calendar"),
    CALENDAR_DATE("calendar_date"),
    BIG_DECIMAL("big_decimal"),
    BIG_INTEGER("big_integer"),
    LOCALE("locale"),
    TIMEZONE("timezone"),
    CURRENCY("currency"),
    CLASS("class"),
    BINARY("binary"),
    TEXT("text"),
    SERIALIZABLE("serializable"),
    CLOB("clob"),
    BLOB("blob"),
    IMM_DATE("imm_date"),
    IMM_TIME("imm_time"),
    IMM_TIMESTAMP("imm_timestamp"),
    IMM_CALENDAR("imm_calendar"),
    IMM_CALENDAR_DATE("imm_calendar_date"),
    IMM_SERIALIZABLE("imm_serializable"),
    IMM_BINARY("imm_binary");

    private final String myValue;

    private HibernateTypeType(String value) {
        this.myValue = value;
    }

    public String getValue() {
        return this.myValue;
    }

    @NonNls
    public String getJavaTypeName() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 16 -> "java.math.BigDecimal";
            case 17 -> "java.math.BigInteger";
            case 22, 33 -> "byte[]";
            case 26 -> "java.sql.Blob";
            case 7 -> "boolean";
            case 6 -> "byte";
            case 14, 30 -> "java.util.Calendar";
            case 15, 31 -> "java.util.Calendar";
            case 5 -> "char";
            case 21 -> "java.lang.Class";
            case 25 -> "java.sql.Clob";
            case 20 -> "java.util.Currency";
            case 11, 27 -> "java.util.Date";
            case 4 -> "double";
            case 3 -> "float";
            case 0 -> "int";
            case 18 -> "java.util.Locale";
            case 1 -> "long";
            case 24, 32 -> "java.io.Serializable";
            case 2 -> "short";
            case 10, 23 -> "java.lang.String";
            case 12, 13, 28, 29 -> "java.util.Date";
            case 19 -> "java.util.TimeZone";
            case 8, 9 -> "boolean";
        };
    }
}

