/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.completion.backend.split;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.platform.completion.backend.split.BackendCompletionLoggerKt;
import com.intellij.platform.completion.backend.split.BackendCompletionSession;
import com.intellij.platform.completion.common.split.protocol.RpcCompletionRequest;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import fleet.multiplatform.shims.ConcurrentHashMap;
import fleet.multiplatform.shims.ConcurrentHashMapKt;
import fleet.util.UID;
import java.util.Map;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/platform/completion/backend/split/BackendCompletionService;", "", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "sessions", "Lfleet/multiplatform/shims/ConcurrentHashMap;", "Lfleet/util/UID;", "Lcom/intellij/platform/completion/backend/split/BackendCompletionSession;", "createSession", "request", "Lcom/intellij/platform/completion/common/split/protocol/RpcCompletionRequest;", "findSession", "closeSession", "", "Companion", "intellij.platform.completion.backend.split"})
public final class BackendCompletionService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final ConcurrentHashMap<UID, BackendCompletionSession> sessions;

    public BackendCompletionService(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.coroutineScope = coroutineScope;
        this.sessions = ConcurrentHashMapKt.ConcurrentHashMap();
    }

    @NotNull
    public final BackendCompletionSession createSession(@NotNull RpcCompletionRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        BackendCompletionSession session = BackendCompletionSession.Companion.create(request, CoroutineScopeKt.childScope$default((CoroutineScope)this.coroutineScope, (String)("BackendCompletionSession id=" + request.getId()), null, (boolean)false, (int)6, null), this.project);
        ((Map)this.sessions).put(request.getId(), session);
        return session;
    }

    @Nullable
    public final BackendCompletionSession findSession(@NotNull RpcCompletionRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return (BackendCompletionSession)this.sessions.get((Object)request.getId());
    }

    public final void closeSession(@NotNull RpcCompletionRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        BackendCompletionSession backendCompletionSession = (BackendCompletionSession)this.sessions.remove((Object)request.getId());
        if (backendCompletionSession == null) {
            BackendCompletionService $this$closeSession_u24lambda_u240 = this;
            boolean bl = false;
            BackendCompletionLoggerKt.getBcLogger().error("No session found for request: " + request);
            return;
        }
        BackendCompletionSession session = backendCompletionSession;
        session.stop();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0086@\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/platform/completion/backend/split/BackendCompletionService$Companion;", "", "<init>", "()V", "getInstanceAsync", "Lcom/intellij/platform/completion/backend/split/BackendCompletionService;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.completion.backend.split"})
    @SourceDebugExtension(value={"SMAP\nBackendCompletionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendCompletionService.kt\ncom/intellij/platform/completion/backend/split/BackendCompletionService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,46:1\n75#2:47\n*S KotlinDebug\n*F\n+ 1 BackendCompletionService.kt\ncom/intellij/platform/completion/backend/split/BackendCompletionService$Companion\n*L\n43#1:47\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Object getInstanceAsync(@NotNull Project project, @NotNull Continuation<? super BackendCompletionService> $completion) {
            ComponentManager $this$serviceAsync$iv = (ComponentManager)project;
            boolean $i$f$serviceAsync = false;
            Intrinsics.checkNotNull((Object)$this$serviceAsync$iv, (String)"null cannot be cast to non-null type com.intellij.openapi.components.ComponentManagerEx");
            return ((ComponentManagerEx)$this$serviceAsync$iv).getServiceAsync(BackendCompletionService.class, $completion);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

