/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.admonition.internal;

import com.vladsch.flexmark.ast.ListItem;
import com.vladsch.flexmark.ast.util.Parsing;
import com.vladsch.flexmark.ext.admonition.AdmonitionBlock;
import com.vladsch.flexmark.ext.admonition.internal.AdmonitionOptions;
import com.vladsch.flexmark.parser.block.AbstractBlockParser;
import com.vladsch.flexmark.parser.block.AbstractBlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockContinue;
import com.vladsch.flexmark.parser.block.BlockParser;
import com.vladsch.flexmark.parser.block.BlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockStart;
import com.vladsch.flexmark.parser.block.CustomBlockParserFactory;
import com.vladsch.flexmark.parser.block.MatchedBlockParser;
import com.vladsch.flexmark.parser.block.ParserState;
import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.mappers.SpecialLeadInHandler;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdmonitionBlockParser
extends AbstractBlockParser {
    private static final String ADMONITION_START_FORMAT = "^(\\?{3}\\+|\\?{3}|!{3})\\s+(%s)(?:\\s+(%s))?\\s*$";
    final AdmonitionBlock block;
    private final AdmonitionOptions options;
    private final int contentIndent;
    private boolean hadBlankLine;

    AdmonitionBlockParser(AdmonitionOptions options, int contentIndent) {
        this.options = options;
        this.contentIndent = contentIndent;
        this.block = new AdmonitionBlock();
    }

    private int getContentIndent() {
        return this.contentIndent;
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    @Override
    public boolean canContain(ParserState state, BlockParser blockParser, Block block) {
        return true;
    }

    @Override
    public BlockContinue tryContinue(ParserState state) {
        int nonSpaceIndex = state.getNextNonSpaceIndex();
        if (state.isBlank()) {
            this.hadBlankLine = true;
            return BlockContinue.atIndex(nonSpaceIndex);
        }
        if (!this.hadBlankLine && this.options.allowLazyContinuation) {
            return BlockContinue.atIndex(nonSpaceIndex);
        }
        if (state.getIndent() >= this.options.contentIndent) {
            int contentIndent = state.getColumn() + this.options.contentIndent;
            return BlockContinue.atColumn(contentIndent);
        }
        return BlockContinue.none();
    }

    @Override
    public void closeBlock(ParserState state) {
        this.block.setCharsFromContent();
    }

    static boolean isMarker(ParserState state, int index, boolean inParagraph, boolean inParagraphListItem, AdmonitionOptions options) {
        boolean allowLeadingSpace = options.allowLeadingSpace;
        boolean interruptsParagraph = options.interruptsParagraph;
        boolean interruptsItemParagraph = options.interruptsItemParagraph;
        boolean withLeadSpacesInterruptsItemParagraph = options.withSpacesInterruptsItemParagraph;
        BasedSequence line = state.getLine();
        if (!(inParagraph && !interruptsParagraph || !allowLeadingSpace && state.getIndent() != 0 || inParagraphListItem && !interruptsItemParagraph)) {
            if (inParagraphListItem && !withLeadSpacesInterruptsItemParagraph) {
                return state.getIndent() == 0;
            }
            return state.getIndent() < state.getParsing().CODE_BLOCK_INDENT;
        }
        return false;
    }

    private static class BlockFactory
    extends AbstractBlockParserFactory {
        private final AdmonitionOptions options;

        BlockFactory(DataHolder options) {
            super(options);
            this.options = new AdmonitionOptions(options);
        }

        @Override
        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            boolean inParagraphListItem;
            if (state.getIndent() >= 4) {
                return BlockStart.none();
            }
            int nextNonSpace = state.getNextNonSpaceIndex();
            BlockParser matched = matchedBlockParser.getBlockParser();
            boolean inParagraph = matched.isParagraphParser();
            boolean bl = inParagraphListItem = inParagraph && matched.getBlock().getParent() instanceof ListItem && matched.getBlock() == matched.getBlock().getParent().getFirstChild();
            if (AdmonitionBlockParser.isMarker(state, nextNonSpace, inParagraph, inParagraphListItem, this.options)) {
                BasedSequence line = state.getLine();
                BasedSequence trySequence = line.subSequence(nextNonSpace, line.length());
                Parsing parsing = state.getParsing();
                Pattern startPattern = Pattern.compile(String.format(AdmonitionBlockParser.ADMONITION_START_FORMAT, parsing.ATTRIBUTENAME, parsing.LINK_TITLE_STRING));
                Matcher matcher = startPattern.matcher(trySequence);
                if (matcher.find()) {
                    BasedSequence openingMarker = line.subSequence(nextNonSpace + matcher.start(1), nextNonSpace + matcher.end(1));
                    BasedSequence info = line.subSequence(nextNonSpace + matcher.start(2), nextNonSpace + matcher.end(2));
                    BasedSequence titleChars = matcher.group(3) == null ? BasedSequence.NULL : line.subSequence(nextNonSpace + matcher.start(3), nextNonSpace + matcher.end(3));
                    int contentOffset = this.options.contentIndent;
                    AdmonitionBlockParser admonitionBlockParser = new AdmonitionBlockParser(this.options, contentOffset);
                    admonitionBlockParser.block.setOpeningMarker(openingMarker);
                    admonitionBlockParser.block.setInfo(info);
                    admonitionBlockParser.block.setTitleChars(titleChars);
                    return BlockStart.of(admonitionBlockParser).atIndex(line.length());
                }
                return BlockStart.none();
            }
            return BlockStart.none();
        }
    }

    static class AdmonitionLeadInHandler
    implements SpecialLeadInHandler {
        static final SpecialLeadInHandler HANDLER = new AdmonitionLeadInHandler();

        AdmonitionLeadInHandler() {
        }

        @Override
        public boolean escape(@NotNull BasedSequence sequence, @Nullable DataHolder options, @NotNull Consumer<CharSequence> consumer) {
            if ((sequence.length() == 3 || sequence.length() == 4 && sequence.charAt(3) == '+') && (sequence.startsWith("???") || sequence.startsWith("!!!"))) {
                consumer.accept("\\");
                consumer.accept(sequence);
                return true;
            }
            return false;
        }

        @Override
        public boolean unEscape(@NotNull BasedSequence sequence, @Nullable DataHolder options, @NotNull Consumer<CharSequence> consumer) {
            if ((sequence.length() == 4 || sequence.length() == 5 && sequence.charAt(4) == '+') && (sequence.startsWith("\\???") || sequence.startsWith("\\!!!"))) {
                consumer.accept((CharSequence)sequence.subSequence(1));
                return true;
            }
            return false;
        }
    }

    public static class Factory
    implements CustomBlockParserFactory {
        @Override
        @Nullable
        public Set<Class<?>> getAfterDependents() {
            return null;
        }

        @Override
        @Nullable
        public Set<Class<?>> getBeforeDependents() {
            return null;
        }

        @Override
        @Nullable
        public SpecialLeadInHandler getLeadInHandler(@NotNull DataHolder options) {
            return AdmonitionLeadInHandler.HANDLER;
        }

        @Override
        public boolean affectsGlobalScope() {
            return false;
        }

        @Override
        @NotNull
        public BlockParserFactory apply(@NotNull DataHolder options) {
            return new BlockFactory(options);
        }
    }
}

