/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.storage;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import org.asamk.signal.manager.api.GroupId;
import org.asamk.signal.manager.storage.recipients.RecipientAddress;
import org.asamk.signal.manager.util.IOUtils;
import org.asamk.signal.manager.util.Utils;
import org.whispersystems.signalservice.api.util.StreamDetails;

public class AvatarStore {
    private final File avatarsPath;

    public AvatarStore(File avatarsPath) {
        this.avatarsPath = avatarsPath;
    }

    public StreamDetails retrieveContactAvatar(RecipientAddress address) throws IOException {
        return this.retrieveAvatar(this.getContactAvatarFile(address));
    }

    public StreamDetails retrieveProfileAvatar(RecipientAddress address) throws IOException {
        return this.retrieveAvatar(this.getProfileAvatarFile(address));
    }

    public StreamDetails retrieveGroupAvatar(GroupId groupId) throws IOException {
        File groupAvatarFile = this.getGroupAvatarFile(groupId);
        return this.retrieveAvatar(groupAvatarFile);
    }

    public void storeContactAvatar(RecipientAddress address, AvatarStorer storer) throws IOException {
        this.storeAvatar(this.getContactAvatarFile(address), storer);
    }

    public void storeProfileAvatar(RecipientAddress address, AvatarStorer storer) throws IOException {
        this.storeAvatar(this.getProfileAvatarFile(address), storer);
    }

    public void storeGroupAvatar(GroupId groupId, AvatarStorer storer) throws IOException {
        this.storeAvatar(this.getGroupAvatarFile(groupId), storer);
    }

    public void deleteProfileAvatar(RecipientAddress address) throws IOException {
        this.deleteAvatar(this.getProfileAvatarFile(address));
    }

    public void deleteGroupAvatar(GroupId groupId) throws IOException {
        this.deleteAvatar(this.getGroupAvatarFile(groupId));
    }

    private StreamDetails retrieveAvatar(File avatarFile) throws IOException {
        if (!avatarFile.exists()) {
            return null;
        }
        return Utils.createStreamDetailsFromFile(avatarFile);
    }

    private void storeAvatar(File avatarFile, AvatarStorer storer) throws IOException {
        this.createAvatarsDir();
        try (FileOutputStream output = new FileOutputStream(avatarFile);){
            storer.store(output);
        }
    }

    private void deleteAvatar(File avatarFile) throws IOException {
        if (avatarFile.exists()) {
            Files.delete(avatarFile.toPath());
        }
    }

    private File getGroupAvatarFile(GroupId groupId) {
        return new File(this.avatarsPath, "group-" + groupId.toBase64().replace("/", "_"));
    }

    private File getContactAvatarFile(RecipientAddress address) {
        return new File(this.avatarsPath, "contact-" + address.getLegacyIdentifier());
    }

    private File getProfileAvatarFile(RecipientAddress address) {
        return new File(this.avatarsPath, "profile-" + address.getLegacyIdentifier());
    }

    private void createAvatarsDir() throws IOException {
        IOUtils.createPrivateDirectories(this.avatarsPath);
    }

    @FunctionalInterface
    public static interface AvatarStorer {
        public void store(OutputStream var1) throws IOException;
    }
}

