/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.storage.recipients;

import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.asamk.signal.manager.api.Pair;
import org.asamk.signal.manager.storage.recipients.RecipientAddress;
import org.asamk.signal.manager.storage.recipients.RecipientId;
import org.asamk.signal.manager.storage.recipients.RecipientWithAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeRecipientHelper {
    private static final Logger logger = LoggerFactory.getLogger(MergeRecipientHelper.class);

    static Pair<RecipientId, List<RecipientId>> resolveRecipientTrustedLocked(Store store, RecipientAddress address) throws SQLException {
        Set<RecipientWithAddress> remainingRecipients;
        Set<RecipientWithAddress> recipients = store.findAllByAddress(address);
        if (recipients.isEmpty()) {
            logger.debug("Got new recipient, serviceId, PNI, number, username are unknown");
            return new Pair<RecipientId, List<RecipientId>>(store.addNewRecipient(address), List.of());
        }
        if (recipients.size() == 1) {
            RecipientWithAddress recipient = (RecipientWithAddress)recipients.stream().findFirst().get();
            if (recipient.address().hasIdentifiersOf(address)) {
                return new Pair<RecipientId, List<RecipientId>>(recipient.id(), List.of());
            }
            if (recipient.address().aci().isEmpty() || address.aci().isEmpty() && (address.pni().isEmpty() || recipient.address().pni().equals(address.pni())) || recipient.address().aci().equals(address.aci())) {
                logger.debug("Got existing recipient {}, updating with high trust address", (Object)recipient.id());
                store.updateRecipientAddress(recipient.id(), address.withOtherIdentifiersFrom(recipient.address()));
                return new Pair<RecipientId, List<RecipientId>>(recipient.id(), List.of());
            }
            logger.debug("Got recipient {} existing with number/pni/username, but different aci, so stripping its number and adding new recipient", (Object)recipient.id());
            store.updateRecipientAddress(recipient.id(), recipient.address().removeIdentifiersFrom(address));
            return new Pair<RecipientId, List<RecipientId>>(store.addNewRecipient(address), List.of());
        }
        Optional<RecipientWithAddress> resultingRecipient = recipients.stream().filter(r -> r.address().aci().isPresent() && r.address().aci().equals(address.aci())).findFirst();
        if (resultingRecipient.isEmpty() && address.pni().isPresent()) {
            resultingRecipient = recipients.stream().filter(r -> r.address().pni().equals(address.pni())).findFirst();
        }
        if (resultingRecipient.isEmpty()) {
            remainingRecipients = recipients;
        } else {
            remainingRecipients = new HashSet<RecipientWithAddress>(recipients);
            remainingRecipients.remove(resultingRecipient.get());
        }
        HashSet<RecipientWithAddress> recipientsToBeMerged = new HashSet<RecipientWithAddress>();
        HashSet<RecipientWithAddress> recipientsToBeStripped = new HashSet<RecipientWithAddress>();
        for (RecipientWithAddress recipientWithAddress : remainingRecipients) {
            if (!recipientWithAddress.address().hasAdditionalIdentifiersThan(address)) {
                recipientsToBeMerged.add(recipientWithAddress);
                continue;
            }
            if (recipientWithAddress.address().hasOnlyPniAndNumber()) {
                recipientsToBeMerged.add(recipientWithAddress);
                continue;
            }
            recipientsToBeStripped.add(recipientWithAddress);
        }
        logger.debug("Got separate recipients for high trust identifiers {}, need to merge ({}, {}) and strip ({})", new Object[]{address, resultingRecipient.map(RecipientWithAddress::address), recipientsToBeMerged.stream().map(r -> r.address().toString()).collect(Collectors.joining(", ")), recipientsToBeStripped.stream().map(r -> r.address().toString()).collect(Collectors.joining(", "))});
        RecipientAddress finalAddress = resultingRecipient.map(RecipientWithAddress::address).orElse(null);
        for (RecipientWithAddress recipient : recipientsToBeMerged) {
            finalAddress = finalAddress == null ? recipient.address() : finalAddress.withOtherIdentifiersFrom(recipient.address());
            store.removeRecipientAddress(recipient.id());
        }
        finalAddress = finalAddress == null ? address : address.withOtherIdentifiersFrom(finalAddress);
        for (RecipientWithAddress recipient : recipientsToBeStripped) {
            store.updateRecipientAddress(recipient.id(), recipient.address().removeIdentifiersFrom(finalAddress));
        }
        List<RecipientId> list = recipientsToBeMerged.stream().map(r -> new RecipientId(r.id().id(), null)).toList();
        if (resultingRecipient.isPresent()) {
            store.updateRecipientAddress(resultingRecipient.get().id(), finalAddress);
            return new Pair<RecipientId, List<RecipientId>>(resultingRecipient.get().id(), list);
        }
        return new Pair<RecipientId, List<RecipientId>>(store.addNewRecipient(finalAddress), list);
    }

    public static interface Store {
        public Set<RecipientWithAddress> findAllByAddress(RecipientAddress var1) throws SQLException;

        public RecipientId addNewRecipient(RecipientAddress var1) throws SQLException;

        public void updateRecipientAddress(RecipientId var1, RecipientAddress var2) throws SQLException;

        public void removeRecipientAddress(RecipientId var1) throws SQLException;
    }
}

