/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.storage.senderKeys;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.asamk.signal.manager.storage.Database;
import org.asamk.signal.manager.storage.Utils;
import org.signal.libsignal.protocol.SignalProtocolAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.push.DistributionId;
import org.whispersystems.signalservice.api.push.ServiceId;
import org.whispersystems.signalservice.api.util.UuidUtil;

public class SenderKeySharedStore {
    private static final Logger logger = LoggerFactory.getLogger(SenderKeySharedStore.class);
    private static final String TABLE_SENDER_KEY_SHARED = "sender_key_shared";
    private final Database database;

    public static void createSql(Connection connection) throws SQLException {
        try (Statement statement = connection.createStatement();){
            statement.executeUpdate("CREATE TABLE sender_key_shared (\n  _id INTEGER PRIMARY KEY,\n  address TEXT NOT NULL,\n  device_id INTEGER NOT NULL,\n  distribution_id BLOB NOT NULL,\n  timestamp INTEGER NOT NULL,\n  UNIQUE(address, device_id, distribution_id)\n) STRICT;\n");
        }
    }

    SenderKeySharedStore(Database database) {
        this.database = database;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Set<SignalProtocolAddress> getSenderKeySharedWith(DistributionId distributionId) {
        try (Connection connection = this.database.getConnection();){
            Set<SignalProtocolAddress> set;
            block14: {
                String sql = "SELECT s.address, s.device_id\nFROM %s AS s\nWHERE s.distribution_id = ?\n".formatted(TABLE_SENDER_KEY_SHARED);
                PreparedStatement statement = connection.prepareStatement(sql);
                try {
                    statement.setBytes(1, UuidUtil.toByteArray((UUID)distributionId.asUuid()));
                    set = Utils.executeQueryForStream(statement, this::getSenderKeySharedEntryFromResultSet).map(k -> new SignalProtocolAddress(k.address, k.deviceId())).collect(Collectors.toSet());
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return set;
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed read from shared sender key store", e);
        }
    }

    public void markSenderKeySharedWith(DistributionId distributionId, Collection<SignalProtocolAddress> addresses) {
        Set<SenderKeySharedEntry> newEntries = addresses.stream().map(a -> new SenderKeySharedEntry(a.getName(), a.getDeviceId())).collect(Collectors.toSet());
        try (Connection connection = this.database.getConnection();){
            connection.setAutoCommit(false);
            this.markSenderKeysSharedWith(connection, distributionId, newEntries);
            connection.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update shared sender key store", e);
        }
    }

    public void clearSenderKeySharedWith(Collection<SignalProtocolAddress> addresses) {
        Set entriesToDelete = addresses.stream().map(a -> new SenderKeySharedEntry(a.getName(), a.getDeviceId())).collect(Collectors.toSet());
        try (Connection connection = this.database.getConnection();){
            connection.setAutoCommit(false);
            String sql = "DELETE FROM %s AS s\nWHERE address = ? AND device_id = ?\n".formatted(TABLE_SENDER_KEY_SHARED);
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                for (SenderKeySharedEntry entry : entriesToDelete) {
                    statement.setString(1, entry.address());
                    statement.setInt(2, entry.deviceId());
                    statement.executeUpdate();
                }
            }
            connection.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update shared sender key store", e);
        }
    }

    public void deleteAll() {
        try (Connection connection = this.database.getConnection();){
            String sql = "DELETE FROM %s AS s\n".formatted(TABLE_SENDER_KEY_SHARED);
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.executeUpdate();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update shared sender key store", e);
        }
    }

    public void deleteAllFor(ServiceId serviceId) {
        try (Connection connection = this.database.getConnection();){
            String sql = "DELETE FROM %s AS s\nWHERE address = ?\n".formatted(TABLE_SENDER_KEY_SHARED);
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setString(1, serviceId.toString());
                statement.executeUpdate();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update shared sender key store", e);
        }
    }

    public void deleteSharedWith(ServiceId serviceId, int deviceId, DistributionId distributionId) {
        try (Connection connection = this.database.getConnection();){
            String sql = "DELETE FROM %s AS s\nWHERE address = ? AND device_id = ? AND distribution_id = ?\n".formatted(TABLE_SENDER_KEY_SHARED);
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setString(1, serviceId.toString());
                statement.setInt(2, deviceId);
                statement.setBytes(3, UuidUtil.toByteArray((UUID)distributionId.asUuid()));
                statement.executeUpdate();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update shared sender key store", e);
        }
    }

    public void deleteAllFor(DistributionId distributionId) {
        try (Connection connection = this.database.getConnection();){
            String sql = "DELETE FROM %s AS s\nWHERE distribution_id = ?\n".formatted(TABLE_SENDER_KEY_SHARED);
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setBytes(1, UuidUtil.toByteArray((UUID)distributionId.asUuid()));
                statement.executeUpdate();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update shared sender key store", e);
        }
    }

    void addLegacySenderKeysShared(Map<DistributionId, Set<SenderKeySharedEntry>> sharedSenderKeys) {
        logger.debug("Migrating legacy sender keys shared to database");
        long start = System.nanoTime();
        try (Connection connection = this.database.getConnection();){
            connection.setAutoCommit(false);
            for (Map.Entry<DistributionId, Set<SenderKeySharedEntry>> entry : sharedSenderKeys.entrySet()) {
                this.markSenderKeysSharedWith(connection, entry.getKey(), entry.getValue());
            }
            connection.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update shared sender key store", e);
        }
        logger.debug("Complete sender keys shared migration took {}ms", (Object)((System.nanoTime() - start) / 1000000L));
    }

    private void markSenderKeysSharedWith(Connection connection, DistributionId distributionId, Set<SenderKeySharedEntry> newEntries) throws SQLException {
        String sql = "INSERT INTO %s (address, device_id, distribution_id, timestamp)\nVALUES (?, ?, ?, ?)\nON CONFLICT (address, device_id, distribution_id) DO UPDATE SET timestamp=excluded.timestamp\n".formatted(TABLE_SENDER_KEY_SHARED);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            for (SenderKeySharedEntry entry : newEntries) {
                statement.setString(1, entry.toString());
                statement.setInt(2, entry.deviceId());
                statement.setBytes(3, UuidUtil.toByteArray((UUID)distributionId.asUuid()));
                statement.setLong(4, System.currentTimeMillis());
                statement.executeUpdate();
            }
        }
    }

    private SenderKeySharedEntry getSenderKeySharedEntryFromResultSet(ResultSet resultSet) throws SQLException {
        String address = resultSet.getString("address");
        int deviceId = resultSet.getInt("device_id");
        return new SenderKeySharedEntry(address, deviceId);
    }

    record SenderKeySharedEntry(String address, int deviceId) {
    }
}

