/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.internal.websocket;

import java.util.Objects;
import java.util.function.Function;
import org.whispersystems.signalservice.api.push.exceptions.MalformedResponseException;
import org.whispersystems.signalservice.internal.ServiceResponse;
import org.whispersystems.signalservice.internal.util.JsonUtil;
import org.whispersystems.signalservice.internal.websocket.DefaultErrorMapper;
import org.whispersystems.signalservice.internal.websocket.ErrorMapper;
import org.whispersystems.signalservice.internal.websocket.ResponseMapper;

public class DefaultResponseMapper<Response>
implements ResponseMapper<Response> {
    private final Class<Response> clazz;
    private final ErrorMapper errorMapper;
    private final CustomResponseMapper<Response> customResponseMapper;

    public static <T> DefaultResponseMapper<T> getDefault(Class<T> clazz) {
        return new DefaultResponseMapper<T>(clazz);
    }

    public static <T> Builder<T> extend(Class<T> clazz) {
        return new Builder<T>(clazz);
    }

    private DefaultResponseMapper(Class<Response> clazz) {
        this(clazz, null, DefaultErrorMapper.getDefault());
    }

    private DefaultResponseMapper(Class<Response> clazz, CustomResponseMapper<Response> customResponseMapper, ErrorMapper errorMapper) {
        this.clazz = clazz;
        this.customResponseMapper = customResponseMapper;
        this.errorMapper = errorMapper;
    }

    @Override
    public ServiceResponse<Response> map(int status, String body, Function<String, String> getHeader, boolean unidentified) {
        Throwable applicationError;
        try {
            applicationError = this.errorMapper.parseError(status, body, getHeader);
        }
        catch (MalformedResponseException e) {
            applicationError = e;
        }
        if (applicationError == null) {
            try {
                if (this.customResponseMapper != null) {
                    return Objects.requireNonNull(this.customResponseMapper.map(status, body, getHeader, unidentified));
                }
                return ServiceResponse.forResult(JsonUtil.fromJsonResponse(body, this.clazz), status, body);
            }
            catch (MalformedResponseException e) {
                applicationError = e;
            }
        }
        return ServiceResponse.forApplicationError(applicationError, status, body);
    }

    public static class Builder<Value> {
        private final Class<Value> clazz;
        private DefaultErrorMapper.Builder errorMapperBuilder = DefaultErrorMapper.extend();
        private CustomResponseMapper<Value> customResponseMapper;

        public Builder(Class<Value> clazz) {
            this.clazz = clazz;
        }

        public Builder<Value> withResponseMapper(CustomResponseMapper<Value> responseMapper) {
            this.customResponseMapper = responseMapper;
            return this;
        }

        public Builder<Value> withCustomError(int status, ErrorMapper errorMapper) {
            this.errorMapperBuilder.withCustom(status, errorMapper);
            return this;
        }

        public ResponseMapper<Value> build() {
            return new DefaultResponseMapper<Value>(this.clazz, this.customResponseMapper, this.errorMapperBuilder.build());
        }
    }

    public static interface CustomResponseMapper<T> {
        public ServiceResponse<T> map(int var1, String var2, Function<String, String> var3, boolean var4) throws MalformedResponseException;
    }
}

