%define name nestedsums
%define version 1.5.2
%define release 1

Summary: C++ library for symbolic expansion of transcendental functions
Name: %{name}
Version: %{version}
Release: %{release}
Copyright: GPL
Group: System Environment/Libraries
Source: http://particlephysics.uni-mainz.de/weinzierl/download/%{name}-%{version}.tar.gz
URL: http://particlephysics.uni-mainz.de/weinzierl/nestedsums/
Packager: Christian Bauer <cbauer@ginac.de>
Prereq: /sbin/install-info
BuildRoot: %{_tmppath}/%{name}-root
Prefix: %{_prefix}

Requires: GiNaC >= 1.5.0

%description
The nestedsums library can be used for the symbolic expansion of a certain
class of transcendental functions.

The library is described in: S. Weinzierl, "Symbolic Expansion of
Transcendental Functions", Comp. Phys. Comm. 145, (2002), 357,
http://arXiv.org/abs/math-ph/0201011


%package devel
Summary: nestedsums development libraries and header files
Group: Development/Libraries
Requires: %{name} = %{version}

%description devel
The nestedsums library can be used for the symbolic expansion of a certain
class of transcendental functions.

The library is described in: S. Weinzierl, "Symbolic Expansion of
Transcendental Functions", Comp. Phys. Comm. 145, (2002), 357,
http://arXiv.org/abs/math-ph/0201011

This package contains the libraries, include files and other resources you
use to develop applications using the nestedsums library.


%prep
%setup -q

%build
CFLAGS=${RPM_OPT_FLAGS} CXXFLAGS=${RPM_OPT_FLAGS} ./configure --prefix=%{_prefix}
if [ -x /usr/bin/getconf ] ; then
  NCPU=$(/usr/bin/getconf _NPROCESSORS_ONLN)
  if [ $NCPU -eq 0 ] ; then
    NCPU=1
  fi
else  
  NCPU=1
fi
PARL=$[ $NCPU + 1 ]
(make -k -j $PARL; exit 0)
make

%install
rm -rf ${RPM_BUILD_ROOT}
make DESTDIR=${RPM_BUILD_ROOT} install

%clean
rm -rf ${RPM_BUILD_ROOT}

%post
/sbin/ldconfig

%postun
/sbin/ldconfig

%files
%defattr(-,root,root)
%doc COPYING ChangeLog
%{_libdir}/*.so.*

%files devel
%defattr(-,root,root)
%{_libdir}/*.a
%{_libdir}/*.la
%{_libdir}/*.so
%{_includedir}/nestedsums/*.h
%{_bindir}/nestedsums-config
%{_datadir}/aclocal/*

%changelog
* Thu Mar 20 2003 Christian Bauer <Christian.Bauer@uni-mainz.de>
- created spec file
