/*
 * Decompiled with CFR 0.152.
 */
package net.sf.launch4j.binding;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.JToggleButton;
import net.sf.launch4j.binding.Binding;
import net.sf.launch4j.binding.BindingException;
import net.sf.launch4j.binding.Bindings;
import net.sf.launch4j.binding.IValidatable;
import net.sf.launch4j.binding.Messages;
import org.apache.commons.beanutils.PropertyUtils;

public class OptComponentBinding
implements Binding,
ActionListener {
    private final Bindings _bindings;
    private final String _property;
    private final Class _clazz;
    private final JToggleButton _button;
    private final boolean _enabledByDefault;

    public OptComponentBinding(Bindings bindings, String property, Class clazz, JToggleButton button, boolean enabledByDefault) {
        if (property == null || clazz == null || button == null) {
            throw new NullPointerException();
        }
        if (property.equals("")) {
            throw new IllegalArgumentException();
        }
        if (!Arrays.asList(clazz.getInterfaces()).contains(IValidatable.class)) {
            throw new IllegalArgumentException(Messages.getString("OptComponentBinding.must.implement") + IValidatable.class);
        }
        this._bindings = bindings;
        this._property = property;
        this._clazz = clazz;
        this._button = button;
        this._button.addActionListener(this);
        this._enabledByDefault = enabledByDefault;
    }

    public String getProperty() {
        return this._property;
    }

    public void clear(IValidatable bean) {
        this._button.setSelected(this._enabledByDefault);
        this.updateComponents();
    }

    public void put(IValidatable bean) {
        try {
            Object component = PropertyUtils.getProperty(bean, this._property);
            this._button.setSelected(component != null);
            this.updateComponents();
        }
        catch (Exception e) {
            throw new BindingException(e);
        }
    }

    public void get(IValidatable bean) {
        try {
            PropertyUtils.setProperty(bean, this._property, this._button.isSelected() ? this._clazz.newInstance() : null);
        }
        catch (Exception e) {
            throw new BindingException(e);
        }
    }

    public void markValid() {
    }

    public void markInvalid() {
    }

    public void setEnabled(boolean enabled) {
    }

    public void actionPerformed(ActionEvent e) {
        this.updateComponents();
    }

    private void updateComponents() {
        this._bindings.setComponentsEnabled(this._property, this._button.isSelected());
    }
}

